/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.pathfinder.Path;

public class YieldJobSite {
    public static BehaviorControl<Villager> create(float speed) {
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.POTENTIAL_JOB_SITE), context.absent(MemoryModuleType.JOB_SITE), context.present(MemoryModuleType.NEAREST_LIVING_ENTITIES), context.registered(MemoryModuleType.WALK_TARGET), context.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)context, (potentialJobSite, jobSite, mobs, walkTarget, lookTarget) -> (world, entity, time) -> {
            if (entity.isBaby()) {
                return false;
            }
            if (entity.getVillagerData().getProfession() != VillagerProfession.NONE) {
                return false;
            }
            BlockPos blockPos = ((GlobalPos)context.get(potentialJobSite)).pos();
            Optional<Holder<PoiType>> optional = world.getPoiManager().getType(blockPos);
            if (optional.isEmpty()) {
                return true;
            }
            ((List)context.get(mobs)).stream().filter(mob -> mob instanceof Villager && mob != entity).map(villager -> (Villager)villager).filter(LivingEntity::isAlive).filter(villager -> YieldJobSite.nearbyWantsJobsite((Holder)optional.get(), villager, blockPos)).findFirst().ifPresent(villager -> {
                walkTarget.erase();
                lookTarget.erase();
                potentialJobSite.erase();
                if (villager.getBrain().getMemory(MemoryModuleType.JOB_SITE).isEmpty()) {
                    BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)villager, blockPos, speed, 1);
                    villager.getBrain().setMemory(MemoryModuleType.POTENTIAL_JOB_SITE, GlobalPos.of(world.dimension(), blockPos));
                    DebugPackets.sendPoiTicketCountPacket(world, blockPos);
                }
            });
            return true;
        }));
    }

    private static boolean nearbyWantsJobsite(Holder<PoiType> poiType, Villager villager, BlockPos pos) {
        boolean bl = villager.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).isPresent();
        if (bl) {
            return false;
        }
        Optional<GlobalPos> optional = villager.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        VillagerProfession villagerProfession = villager.getVillagerData().getProfession();
        if (villagerProfession.heldJobSite().test(poiType)) {
            if (optional.isEmpty()) {
                return YieldJobSite.canReachPos(villager, pos, poiType.value());
            }
            return optional.get().pos().equals(pos);
        }
        return false;
    }

    private static boolean canReachPos(PathfinderMob entity, BlockPos pos, PoiType poiType) {
        Path path = entity.getNavigation().createPath(pos, poiType.validRange());
        return path != null && path.canReach();
    }
}

