/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StartAttacking {
    public static <E extends Mob> BehaviorControl<E> create(Function<E, Optional<? extends LivingEntity>> targetGetter) {
        return StartAttacking.create(entityinsentient -> true, targetGetter);
    }

    public static <E extends Mob> BehaviorControl<E> create(Predicate<E> startCondition, Function<E, Optional<? extends LivingEntity>> targetGetter) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.absent(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i) -> {
            if (!startCondition.test(entityinsentient)) {
                return false;
            }
            Optional optional = (Optional)targetGetter.apply(entityinsentient);
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity entityliving = (LivingEntity)optional.get();
            if (!entityinsentient.canAttack(entityliving)) {
                return false;
            }
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, entityliving, entityliving instanceof ServerPlayer ? EntityTargetEvent.TargetReason.CLOSEST_PLAYER : EntityTargetEvent.TargetReason.CLOSEST_ENTITY);
            if (event.isCancelled()) {
                return false;
            }
            if (event.getTarget() == null) {
                memoryaccessor.erase();
                return true;
            }
            entityliving = ((CraftLivingEntity)event.getTarget()).getHandle();
            memoryaccessor.set(entityliving);
            memoryaccessor1.erase();
            return true;
        }));
    }
}

