/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class SetWalkTargetFromLookTarget {
    public static OneShot<LivingEntity> create(float speed, int completionRange) {
        return SetWalkTargetFromLookTarget.create(entity -> true, entity -> Float.valueOf(speed), completionRange);
    }

    public static OneShot<LivingEntity> create(Predicate<LivingEntity> predicate, Function<LivingEntity, Float> speed, int completionRange) {
        return BehaviorBuilder.create(context -> context.group(context.absent(MemoryModuleType.WALK_TARGET), context.present(MemoryModuleType.LOOK_TARGET)).apply((Applicative)context, (walkTarget, lookTarget) -> (world, entity, time) -> {
            if (!predicate.test(entity)) {
                return false;
            }
            walkTarget.set(new WalkTarget((PositionTracker)context.get(lookTarget), ((Float)speed.apply(entity)).floatValue(), completionRange));
            return true;
        }));
    }
}

