/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class JumpOnBed
extends Behavior<Mob> {
    private static final int MAX_TIME_TO_REACH_BED = 100;
    private static final int MIN_JUMPS = 3;
    private static final int MAX_JUMPS = 6;
    private static final int COOLDOWN_BETWEEN_JUMPS = 5;
    private final float speedModifier;
    @Nullable
    private BlockPos targetBed;
    private int remainingTimeToReachBed;
    private int remainingJumps;
    private int remainingCooldownUntilNextJump;

    public JumpOnBed(float walkSpeed) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.NEAREST_BED, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = walkSpeed;
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, Mob entity) {
        return entity.isBaby() && this.nearBed(world, entity);
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, Mob mob, long l) {
        super.start(serverLevel, mob, l);
        this.getNearestBed(mob).ifPresent(pos -> {
            this.targetBed = pos;
            this.remainingTimeToReachBed = 100;
            this.remainingJumps = 3 + serverLevel.random.nextInt(4);
            this.remainingCooldownUntilNextJump = 0;
            this.startWalkingTowardsBed(mob, (BlockPos)pos);
        });
    }

    @Override
    @Override
    protected void stop(ServerLevel world, Mob entity, long time) {
        super.stop(world, entity, time);
        this.targetBed = null;
        this.remainingTimeToReachBed = 0;
        this.remainingJumps = 0;
        this.remainingCooldownUntilNextJump = 0;
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel serverLevel, Mob mob, long l) {
        return mob.isBaby() && this.targetBed != null && this.isBed(serverLevel, this.targetBed) && !this.tiredOfWalking(serverLevel, mob) && !this.tiredOfJumping(serverLevel, mob);
    }

    @Override
    @Override
    protected boolean timedOut(long time) {
        return false;
    }

    @Override
    @Override
    protected void tick(ServerLevel serverLevel, Mob mob, long l) {
        if (!this.onOrOverBed(serverLevel, mob)) {
            --this.remainingTimeToReachBed;
            return;
        }
        if (this.remainingCooldownUntilNextJump > 0) {
            --this.remainingCooldownUntilNextJump;
            return;
        }
        if (this.onBedSurface(serverLevel, mob)) {
            mob.getJumpControl().jump();
            --this.remainingJumps;
            this.remainingCooldownUntilNextJump = 5;
        }
    }

    private void startWalkingTowardsBed(Mob mob, BlockPos pos) {
        mob.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(pos, this.speedModifier, 0));
    }

    private boolean nearBed(ServerLevel world, Mob mob) {
        return this.onOrOverBed(world, mob) || this.getNearestBed(mob).isPresent();
    }

    private boolean onOrOverBed(ServerLevel world, Mob mob) {
        BlockPos blockPos = mob.blockPosition();
        BlockPos blockPos2 = blockPos.below();
        return this.isBed(world, blockPos) || this.isBed(world, blockPos2);
    }

    private boolean onBedSurface(ServerLevel world, Mob mob) {
        return this.isBed(world, mob.blockPosition());
    }

    private boolean isBed(ServerLevel world, BlockPos pos) {
        return world.getBlockState(pos).is(BlockTags.BEDS);
    }

    private Optional<BlockPos> getNearestBed(Mob mob) {
        return mob.getBrain().getMemory(MemoryModuleType.NEAREST_BED);
    }

    private boolean tiredOfWalking(ServerLevel world, Mob mob) {
        return !this.onOrOverBed(world, mob) && this.remainingTimeToReachBed <= 0;
    }

    private boolean tiredOfJumping(ServerLevel world, Mob mob) {
        return this.onOrOverBed(world, mob) && this.remainingJumps <= 0;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel world, LivingEntity entity, long time) {
        return this.canStillUse(world, (Mob)entity, time);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel world, LivingEntity entity, long time) {
        this.tick(world, (Mob)entity, time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (Mob)entity, time);
    }
}

