/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;

public class GoToTargetLocation {
    private static BlockPos getNearbyPos(Mob mob, BlockPos pos) {
        RandomSource randomSource = mob.level().random;
        return pos.offset(GoToTargetLocation.getRandomOffset(randomSource), 0, GoToTargetLocation.getRandomOffset(randomSource));
    }

    private static int getRandomOffset(RandomSource random) {
        return random.nextInt(3) - 1;
    }

    public static <E extends Mob> OneShot<E> create(MemoryModuleType<BlockPos> posModule, int completionRange, float speed) {
        return BehaviorBuilder.create(context -> context.group(context.present(posModule), context.absent(MemoryModuleType.ATTACK_TARGET), context.absent(MemoryModuleType.WALK_TARGET), context.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)context, (pos, attackTarget, walkTarget, lookTarget) -> (world, entity, time) -> {
            BlockPos blockPos = (BlockPos)context.get(pos);
            boolean bl = blockPos.closerThan(entity.blockPosition(), completionRange);
            if (!bl) {
                BehaviorUtils.setWalkAndLookTargetMemories(entity, GoToTargetLocation.getNearbyPos(entity, blockPos), speed, completionRange);
            }
            return true;
        }));
    }
}

