/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.phys.Vec3;

public class EntityTracker
implements PositionTracker {
    private final Entity entity;
    private final boolean trackEyeHeight;

    public EntityTracker(Entity entity, boolean useEyeHeight) {
        this.entity = entity;
        this.trackEyeHeight = useEyeHeight;
    }

    @Override
    @Override
    public Vec3 currentPosition() {
        return this.trackEyeHeight ? this.entity.position().add(0.0, this.entity.getEyeHeight(), 0.0) : this.entity.position();
    }

    @Override
    @Override
    public BlockPos currentBlockPosition() {
        return this.entity.blockPosition();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Override
    public boolean isVisibleBy(LivingEntity entity) {
        void livingEntity2;
        Entity entity2 = this.entity;
        if (!(entity2 instanceof LivingEntity)) {
            return true;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        if (!livingEntity2.isAlive()) {
            return false;
        }
        Optional<NearestVisibleLivingEntities> optional = entity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return optional.isPresent() && optional.get().contains((LivingEntity)livingEntity2);
    }

    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String toString() {
        return "EntityTracker for " + String.valueOf(this.entity);
    }
}

