/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface SlotAccess {
    public static final SlotAccess NULL = new SlotAccess(){

        @Override
        @Override
        public ItemStack get() {
            return ItemStack.EMPTY;
        }

        @Override
        @Override
        public boolean set(ItemStack stack) {
            return false;
        }
    };

    public static SlotAccess of(final Supplier<ItemStack> getter, final Consumer<ItemStack> setter) {
        return new SlotAccess(){

            @Override
            @Override
            public ItemStack get() {
                return (ItemStack)getter.get();
            }

            @Override
            @Override
            public boolean set(ItemStack stack) {
                setter.accept(stack);
                return true;
            }
        };
    }

    public static SlotAccess forContainer(final Container inventory, final int index, final Predicate<ItemStack> stackFilter) {
        return new SlotAccess(){

            @Override
            @Override
            public ItemStack get() {
                return inventory.getItem(index);
            }

            @Override
            @Override
            public boolean set(ItemStack stack) {
                if (!stackFilter.test(stack)) {
                    return false;
                }
                inventory.setItem(index, stack);
                return true;
            }
        };
    }

    public static SlotAccess forContainer(Container inventory, int index) {
        return SlotAccess.forContainer(inventory, index, stack -> true);
    }

    public static SlotAccess forEquipmentSlot(final LivingEntity entity, final EquipmentSlot slot, final Predicate<ItemStack> filter) {
        return new SlotAccess(){

            @Override
            @Override
            public ItemStack get() {
                return entity.getItemBySlot(slot);
            }

            @Override
            @Override
            public boolean set(ItemStack stack) {
                if (!filter.test(stack)) {
                    return false;
                }
                entity.setItemSlot(slot, stack);
                return true;
            }
        };
    }

    public static SlotAccess forEquipmentSlot(LivingEntity entity, EquipmentSlot slot) {
        return SlotAccess.forEquipmentSlot(entity, slot, stack -> true);
    }

    public ItemStack get();

    public boolean set(ItemStack var1);
}

