/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.world.item.ItemStack;

public class Crackiness {
    public static final Crackiness GOLEM = new Crackiness(0.75f, 0.5f, 0.25f);
    public static final Crackiness WOLF_ARMOR = new Crackiness(0.95f, 0.69f, 0.32f);
    private final float fractionLow;
    private final float fractionMedium;
    private final float fractionHigh;

    private Crackiness(float lowCrackThreshold, float mediumCrackThreshold, float highCrackThreshold) {
        this.fractionLow = lowCrackThreshold;
        this.fractionMedium = mediumCrackThreshold;
        this.fractionHigh = highCrackThreshold;
    }

    public Level byFraction(float health) {
        if (health < this.fractionHigh) {
            return Level.HIGH;
        }
        if (health < this.fractionMedium) {
            return Level.MEDIUM;
        }
        if (health < this.fractionLow) {
            return Level.LOW;
        }
        return Level.NONE;
    }

    public Level byDamage(ItemStack stack) {
        if (!stack.isDamageableItem()) {
            return Level.NONE;
        }
        return this.byDamage(stack.getDamageValue(), stack.getMaxDamage());
    }

    public Level byDamage(int currentDamage, int maxDamage) {
        return this.byFraction((float)(maxDamage - currentDamage) / (float)maxDamage);
    }

    public static enum Level {
        NONE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

