/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;

class BadOmenMobEffect
extends MobEffect {
    protected BadOmenMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    @Override
    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    @Override
    @Override
    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Raid raid;
        ServerLevel serverLevel;
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).isSpectator() && (serverLevel = serverPlayer.serverLevel()).getDifficulty() != Difficulty.PEACEFUL && serverLevel.isVillage(serverPlayer.blockPosition()) && ((raid = serverLevel.getRaidAt(serverPlayer.blockPosition())) == null || raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel())) {
            serverPlayer.addEffect(new MobEffectInstance(MobEffects.RAID_OMEN, 600, amplifier));
            serverPlayer.setRaidOmenPosition(serverPlayer.blockPosition());
            return false;
        }
        return true;
    }
}

