/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class UniformFloat
extends FloatProvider {
    public static final MapCodec<UniformFloat> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("min_inclusive").forGetter(provider -> Float.valueOf(provider.minInclusive)), (App)Codec.FLOAT.fieldOf("max_exclusive").forGetter(provider -> Float.valueOf(provider.maxExclusive))).apply((Applicative)instance, UniformFloat::new)).validate(provider -> {
        if (provider.maxExclusive <= provider.minInclusive) {
            return DataResult.error(() -> "Max must be larger than min, min_inclusive: " + uniformFloat.minInclusive + ", max_exclusive: " + uniformFloat.maxExclusive);
        }
        return DataResult.success((Object)provider);
    });
    private final float minInclusive;
    private final float maxExclusive;

    private UniformFloat(float min, float max) {
        this.minInclusive = min;
        this.maxExclusive = max;
    }

    public static UniformFloat of(float min, float max) {
        if (max <= min) {
            throw new IllegalArgumentException("Max must exceed min");
        }
        return new UniformFloat(min, max);
    }

    @Override
    @Override
    public float sample(RandomSource random) {
        return Mth.randomBetween(random, this.minInclusive, this.maxExclusive);
    }

    @Override
    @Override
    public float getMinValue() {
        return this.minInclusive;
    }

    @Override
    @Override
    public float getMaxValue() {
        return this.maxExclusive;
    }

    @Override
    @Override
    public FloatProviderType<?> getType() {
        return FloatProviderType.UNIFORM;
    }

    @Override
    public String toString() {
        return "[" + this.minInclusive + "-" + this.maxExclusive + "]";
    }
}

