/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static int getTotalWeight(List<? extends WeightedEntry> pool) {
        long l = 0L;
        for (WeightedEntry weightedEntry : pool) {
            l += (long)weightedEntry.getWeight().asInt();
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource random, List<T> pool, int totalWeight) {
        if (totalWeight < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int i = random.nextInt(totalWeight);
        return WeightedRandom.getWeightedItem(pool, i);
    }

    public static <T extends WeightedEntry> Optional<T> getWeightedItem(List<T> pool, int totalWeight) {
        for (WeightedEntry weightedEntry : pool) {
            if ((totalWeight -= weightedEntry.getWeight().asInt()) >= 0) continue;
            return Optional.of(weightedEntry);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource random, List<T> pool) {
        return WeightedRandom.getRandomItem(random, pool, WeightedRandom.getTotalWeight(pool));
    }
}

