/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;
import net.minecraft.util.parsing.packrat.commands.ResourceSuggestion;

public abstract class ResourceLookupRule<C, V>
implements Rule<StringReader, V>,
ResourceSuggestion {
    private final Atom<ResourceLocation> idParser;
    protected final C context;

    protected ResourceLookupRule(Atom<ResourceLocation> symbol, C callbacks) {
        this.idParser = symbol;
        this.context = callbacks;
    }

    @Override
    @Override
    public Optional<V> parse(ParseState<StringReader> state) {
        state.input().skipWhitespace();
        int i = state.mark();
        Optional<ResourceLocation> optional = state.parse(this.idParser);
        if (optional.isPresent()) {
            try {
                return Optional.of(this.validateElement((ImmutableStringReader)state.input(), optional.get()));
            }
            catch (Exception exception) {
                state.errorCollector().store(i, this, exception);
                return Optional.empty();
            }
        }
        state.errorCollector().store(i, this, ResourceLocation.ERROR_INVALID.createWithContext((ImmutableStringReader)state.input()));
        return Optional.empty();
    }

    protected abstract V validateElement(ImmutableStringReader var1, ResourceLocation var2) throws Exception;
}

