/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debugchart;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.network.protocol.game.ClientboundDebugSamplePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.debugchart.RemoteDebugSampleType;

public class DebugSampleSubscriptionTracker {
    public static final int STOP_SENDING_AFTER_TICKS = 200;
    public static final int STOP_SENDING_AFTER_MS = 10000;
    private final PlayerList playerList;
    private final EnumMap<RemoteDebugSampleType, Map<ServerPlayer, SubscriptionStartedAt>> subscriptions;
    private final Queue<SubscriptionRequest> subscriptionRequestQueue = new LinkedList<SubscriptionRequest>();

    public DebugSampleSubscriptionTracker(PlayerList playerManager) {
        this.playerList = playerManager;
        this.subscriptions = new EnumMap(RemoteDebugSampleType.class);
        for (RemoteDebugSampleType remoteDebugSampleType : RemoteDebugSampleType.values()) {
            this.subscriptions.put(remoteDebugSampleType, Maps.newHashMap());
        }
    }

    public boolean shouldLogSamples(RemoteDebugSampleType type) {
        return !this.subscriptions.get((Object)type).isEmpty();
    }

    public void broadcast(ClientboundDebugSamplePacket packet) {
        Set<ServerPlayer> set = this.subscriptions.get((Object)packet.debugSampleType()).keySet();
        for (ServerPlayer serverPlayer : set) {
            serverPlayer.connection.send(packet);
        }
    }

    public void subscribe(ServerPlayer player, RemoteDebugSampleType type) {
        if (this.playerList.isOp(player.getGameProfile())) {
            this.subscriptionRequestQueue.add(new SubscriptionRequest(player, type));
        }
    }

    public void tick(int tick) {
        long l = Util.getMillis();
        this.handleSubscriptions(l, tick);
        this.handleUnsubscriptions(l, tick);
    }

    private void handleSubscriptions(long time, int tick) {
        for (SubscriptionRequest subscriptionRequest : this.subscriptionRequestQueue) {
            this.subscriptions.get((Object)subscriptionRequest.sampleType()).put(subscriptionRequest.player(), new SubscriptionStartedAt(time, tick));
        }
    }

    private void handleUnsubscriptions(long measuringTimeMs, int tick) {
        for (Map<ServerPlayer, SubscriptionStartedAt> map : this.subscriptions.values()) {
            map.entrySet().removeIf(entry -> {
                boolean bl = !this.playerList.isOp(((ServerPlayer)entry.getKey()).getGameProfile());
                SubscriptionStartedAt subscriptionStartedAt = (SubscriptionStartedAt)entry.getValue();
                return bl || tick > subscriptionStartedAt.tick() + 200 && measuringTimeMs > subscriptionStartedAt.millis() + 10000L;
            });
        }
    }

    record SubscriptionRequest(ServerPlayer player, RemoteDebugSampleType sampleType) {
    }

    record SubscriptionStartedAt(long millis, int tick) {
    }
}

