/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;

public class ZombieVillagerRebuildXpFix
extends NamedEntityFix {
    public ZombieVillagerRebuildXpFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType, "Zombie Villager XP rebuild", References.ENTITY, "minecraft:zombie_villager");
    }

    @Override
    @Override
    protected Typed<?> fix(Typed<?> inputTyped) {
        return inputTyped.update(DSL.remainderFinder(), zombieVillagerDynamic -> {
            Optional optional = zombieVillagerDynamic.get("Xp").asNumber().result();
            if (optional.isEmpty()) {
                int i = zombieVillagerDynamic.get("VillagerData").get("level").asInt(1);
                return zombieVillagerDynamic.set("Xp", zombieVillagerDynamic.createInt(VillagerRebuildLevelAndXpFix.getMinXpPerLevel(i)));
            }
            return zombieVillagerDynamic;
        });
    }
}

