/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.PointFreeRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.BitSet;
import net.minecraft.Util;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema outputSchema, boolean changesType, String name, DSL.TypeReference type, String choiceName) {
        super(outputSchema, changesType);
        this.name = name;
        this.type = type;
        this.entityName = choiceName;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(this.type);
        Type type2 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type type3 = this.getOutputSchema().getType(this.type);
        Type type4 = this.getOutputSchema().getChoiceType(this.type, this.entityName);
        OpticFinder opticFinder = DSL.namedChoice((String)this.entityName, (Type)type2);
        Type type5 = type2.all(NamedEntityWriteReadFix.typePatcher(type, type3), true, false).view().newType();
        return this.fix(type, type3, opticFinder, type4, type5);
    }

    private <S, T, A, B> TypeRewriteRule fix(Type<S> inputType, Type<T> outputType, OpticFinder<A> opticFinder, Type<B> outputSubtype, Type<?> rewrittenType) {
        return this.fixTypeEverywhere(this.name, inputType, outputType, dynamicOps -> input -> {
            Typed typed = new Typed(inputType, dynamicOps, input);
            return typed.update(opticFinder, outputSubtype, object -> {
                Typed typed = new Typed(rewrittenType, dynamicOps, object);
                return Util.writeAndReadTypedOrThrow(typed, outputSubtype, this::fix).getValue();
            }).getValue();
        });
    }

    private static <A, B> TypeRewriteRule typePatcher(Type<A> inputSubtype, Type<B> outputSubtype) {
        RewriteResult rewriteResult = RewriteResult.create((View)View.create((String)"Patcher", inputSubtype, outputSubtype, dynamicOps -> object -> {
            throw new UnsupportedOperationException();
        }), (BitSet)new BitSet());
        return TypeRewriteRule.everywhere((TypeRewriteRule)TypeRewriteRule.ifSame(inputSubtype, (RewriteResult)rewriteResult), (PointFreeRule)PointFreeRule.nop(), (boolean)true, (boolean)true);
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

