/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.util.datafix.fixes.References;

public class EntityPaintingItemFrameDirectionFix
extends DataFix {
    private static final int[][] DIRECTIONS = new int[][]{{0, 0, 1}, {-1, 0, 0}, {0, 0, -1}, {1, 0, 0}};

    public EntityPaintingItemFrameDirectionFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    private Dynamic<?> doFix(Dynamic<?> entityDynamic, boolean isPainting, boolean isItemFrame) {
        if ((isPainting || isItemFrame) && entityDynamic.get("Facing").asNumber().result().isEmpty()) {
            int j;
            if (entityDynamic.get("Direction").asNumber().result().isPresent()) {
                int i = entityDynamic.get("Direction").asByte((byte)0) % DIRECTIONS.length;
                int[] is = DIRECTIONS[i];
                entityDynamic = entityDynamic.set("TileX", entityDynamic.createInt(entityDynamic.get("TileX").asInt(0) + is[0]));
                entityDynamic = entityDynamic.set("TileY", entityDynamic.createInt(entityDynamic.get("TileY").asInt(0) + is[1]));
                entityDynamic = entityDynamic.set("TileZ", entityDynamic.createInt(entityDynamic.get("TileZ").asInt(0) + is[2]));
                entityDynamic = entityDynamic.remove("Direction");
                if (isItemFrame && entityDynamic.get("ItemRotation").asNumber().result().isPresent()) {
                    entityDynamic = entityDynamic.set("ItemRotation", entityDynamic.createByte((byte)(entityDynamic.get("ItemRotation").asByte((byte)0) * 2)));
                }
            } else {
                j = entityDynamic.get("Dir").asByte((byte)0) % DIRECTIONS.length;
                entityDynamic = entityDynamic.remove("Dir");
            }
            entityDynamic = entityDynamic.set("Facing", entityDynamic.createByte((byte)j));
        }
        return entityDynamic;
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getChoiceType(References.ENTITY, "Painting");
        OpticFinder opticFinder = DSL.namedChoice((String)"Painting", (Type)type);
        Type type2 = this.getInputSchema().getChoiceType(References.ENTITY, "ItemFrame");
        OpticFinder opticFinder2 = DSL.namedChoice((String)"ItemFrame", (Type)type2);
        Type type3 = this.getInputSchema().getType(References.ENTITY);
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhereTyped("EntityPaintingFix", type3, entityTyped -> entityTyped.updateTyped(opticFinder, type, paintingTyped -> paintingTyped.update(DSL.remainderFinder(), paintingDynamic -> this.doFix((Dynamic<?>)((Object)((Object)((Object)paintingDynamic))), true, false))));
        TypeRewriteRule typeRewriteRule2 = this.fixTypeEverywhereTyped("EntityItemFrameFix", type3, entityTyped -> entityTyped.updateTyped(opticFinder2, type2, itemFrameTyped -> itemFrameTyped.update(DSL.remainderFinder(), itemFrameDynamic -> this.doFix((Dynamic<?>)((Object)((Object)((Object)itemFrameDynamic))), false, true))));
        return TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule)typeRewriteRule2);
    }
}

