/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class EntityHorseSaddleFix
extends NamedEntityFix {
    public EntityHorseSaddleFix(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType, "EntityHorseSaddleFix", References.ENTITY, "EntityHorse");
    }

    @Override
    @Override
    protected Typed<?> fix(Typed<?> inputTyped) {
        OpticFinder opticFinder = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        Type type = this.getInputSchema().getTypeRaw(References.ITEM_STACK);
        OpticFinder opticFinder2 = DSL.fieldFinder((String)"SaddleItem", (Type)type);
        Optional optional = inputTyped.getOptionalTyped(opticFinder2);
        Dynamic dynamic = (Dynamic)((Object)inputTyped.get(DSL.remainderFinder()));
        if (optional.isEmpty() && dynamic.get("Saddle").asBoolean(false)) {
            Typed typed = (Typed)type.pointTyped(inputTyped.getOps()).orElseThrow(IllegalStateException::new);
            typed = typed.set(opticFinder, (Object)Pair.of((Object)References.ITEM_NAME.typeName(), (Object)"minecraft:saddle"));
            Dynamic dynamic2 = dynamic.emptyMap();
            dynamic2 = dynamic2.set("Count", dynamic2.createByte((byte)1));
            dynamic2 = dynamic2.set("Damage", dynamic2.createShort((short)0));
            typed = typed.set(DSL.remainderFinder(), dynamic2);
            dynamic.remove("Saddle");
            return inputTyped.set(opticFinder2, typed).set(DSL.remainderFinder(), (Object)dynamic);
        }
        return inputTyped;
    }
}

