/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C, I extends ToFloatFunction<C>>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String parityString();

    public CubicSpline<C, I> mapAll(CoordinateVisitor<I> var1);

    public static <C, I extends ToFloatFunction<C>> Codec<CubicSpline<C, I>> codec(Codec<I> locationFunctionCodec) {
        record Point<C, I extends ToFloatFunction<C>>(float location, CubicSpline<C, I> value, float derivative) {
        }
        MutableObject mutableObject = new MutableObject();
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("location").forGetter(Point::location), (App)Codec.lazyInitialized(() -> ((MutableObject)mutableObject).getValue()).fieldOf("value").forGetter(Point::value), (App)Codec.FLOAT.fieldOf("derivative").forGetter(Point::derivative)).apply((Applicative)instance, (location, value, derivative) -> new Point((float)location, value, (float)derivative)));
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)locationFunctionCodec.fieldOf("coordinate").forGetter(Multipoint::coordinate), (App)ExtraCodecs.nonEmptyList(codec.listOf()).fieldOf("points").forGetter(spline -> IntStream.range(0, spline.locations.length).mapToObj(index -> new Point(spline.locations()[index], spline.values().get(index), spline.derivatives()[index])).toList())).apply((Applicative)instance, (locationFunction, splines) -> {
            float[] fs = new float[splines.size()];
            ImmutableList.Builder builder = ImmutableList.builder();
            float[] gs = new float[splines.size()];
            for (int i = 0; i < splines.size(); ++i) {
                Point lv = (Point)splines.get(i);
                fs[i] = lv.location();
                builder.add(lv.value());
                gs[i] = lv.derivative();
            }
            return Multipoint.create(locationFunction, fs, builder.build(), gs);
        }));
        mutableObject.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)codec2).xmap(either -> (CubicSpline)((Object)either.map(Constant::new, spline -> spline)), spline -> {
            Either either;
            if (spline instanceof Constant) {
                Constant constant = (Constant)spline;
                either = Either.left(Float.valueOf(constant.value()));
            } else {
                either = Either.right((Multipoint)spline);
            }
            return either;
        }));
        return (Codec)mutableObject.getValue();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> constant(float value) {
        return new Constant(value);
    }

    public static <C, I extends ToFloatFunction<C>> Builder<C, I> builder(I locationFunction) {
        return new Builder(locationFunction);
    }

    public static <C, I extends ToFloatFunction<C>> Builder<C, I> builder(I locationFunction, ToFloatFunction<Float> amplifier) {
        return new Builder(locationFunction, amplifier);
    }

    @VisibleForDebug
    public record Constant<C, I extends ToFloatFunction<C>>(float value) implements CubicSpline<C, I>
    {
        @Override
        @Override
        public float apply(C x) {
            return this.value;
        }

        @Override
        @Override
        public String parityString() {
            return String.format(Locale.ROOT, "k=%.3f", Float.valueOf(this.value));
        }

        @Override
        @Override
        public float minValue() {
            return this.value;
        }

        @Override
        @Override
        public float maxValue() {
            return this.value;
        }

        @Override
        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> visitor) {
            return this;
        }
    }

    public static final class Builder<C, I extends ToFloatFunction<C>> {
        private final I coordinate;
        private final ToFloatFunction<Float> valueTransformer;
        private final FloatList locations = new FloatArrayList();
        private final List<CubicSpline<C, I>> values = Lists.newArrayList();
        private final FloatList derivatives = new FloatArrayList();

        protected Builder(I locationFunction) {
            this(locationFunction, ToFloatFunction.IDENTITY);
        }

        protected Builder(I locationFunction, ToFloatFunction<Float> amplifier) {
            this.coordinate = locationFunction;
            this.valueTransformer = amplifier;
        }

        public Builder<C, I> addPoint(float location, float value) {
            return this.addPoint(location, new Constant(this.valueTransformer.apply(Float.valueOf(value))), 0.0f);
        }

        public Builder<C, I> addPoint(float location, float value, float derivative) {
            return this.addPoint(location, new Constant(this.valueTransformer.apply(Float.valueOf(value))), derivative);
        }

        public Builder<C, I> addPoint(float location, CubicSpline<C, I> value) {
            return this.addPoint(location, value, 0.0f);
        }

        private Builder<C, I> addPoint(float location, CubicSpline<C, I> value, float derivative) {
            if (!this.locations.isEmpty() && location <= this.locations.getFloat(this.locations.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.locations.add(location);
            this.values.add(value);
            this.derivatives.add(derivative);
            return this;
        }

        public CubicSpline<C, I> build() {
            if (this.locations.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return Multipoint.create(this.coordinate, this.locations.toFloatArray(), ImmutableList.copyOf(this.values), this.derivatives.toFloatArray());
        }
    }

    @VisibleForDebug
    public record Multipoint<C, I extends ToFloatFunction<C>>(I coordinate, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives, float minValue, float maxValue) implements CubicSpline<C, I>
    {
        public Multipoint {
            Multipoint.validateSizes(fs, list, gs);
        }

        static <C, I extends ToFloatFunction<C>> Multipoint<C, I> create(I locationFunction, float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            Multipoint.validateSizes(locations, values, derivatives);
            int i = locations.length - 1;
            float f = Float.POSITIVE_INFINITY;
            float g = Float.NEGATIVE_INFINITY;
            float h = locationFunction.minValue();
            float j = locationFunction.maxValue();
            if (h < locations[0]) {
                float k = Multipoint.linearExtend(h, locations, values.get(0).minValue(), derivatives, 0);
                float l = Multipoint.linearExtend(h, locations, values.get(0).maxValue(), derivatives, 0);
                f = Math.min(f, Math.min(k, l));
                g = Math.max(g, Math.max(k, l));
            }
            if (j > locations[i]) {
                float m = Multipoint.linearExtend(j, locations, values.get(i).minValue(), derivatives, i);
                float n = Multipoint.linearExtend(j, locations, values.get(i).maxValue(), derivatives, i);
                f = Math.min(f, Math.min(m, n));
                g = Math.max(g, Math.max(m, n));
            }
            for (CubicSpline<C, I> cubicSpline : values) {
                f = Math.min(f, cubicSpline.minValue());
                g = Math.max(g, cubicSpline.maxValue());
            }
            for (int o = 0; o < i; ++o) {
                float p = locations[o];
                float q = locations[o + 1];
                float r = q - p;
                CubicSpline<C, I> cubicSpline2 = values.get(o);
                CubicSpline<C, I> cubicSpline3 = values.get(o + 1);
                float s = cubicSpline2.minValue();
                float t = cubicSpline2.maxValue();
                float u = cubicSpline3.minValue();
                float v = cubicSpline3.maxValue();
                float w = derivatives[o];
                float x = derivatives[o + 1];
                if (w == 0.0f && x == 0.0f) continue;
                float y = w * r;
                float z = x * r;
                float aa = Math.min(s, u);
                float ab = Math.max(t, v);
                float ac = y - v + s;
                float ad = y - u + t;
                float ae = -z + u - t;
                float af = -z + v - s;
                float ag = Math.min(ac, ae);
                float ah = Math.max(ad, af);
                f = Math.min(f, aa + 0.25f * ag);
                g = Math.max(g, ab + 0.25f * ah);
            }
            return new Multipoint<C, I>(locationFunction, locations, values, derivatives, f, g);
        }

        private static float linearExtend(float point, float[] locations, float value, float[] derivatives, int i) {
            float f = derivatives[i];
            if (f == 0.0f) {
                return value;
            }
            return value + f * (point - locations[i]);
        }

        private static <C, I extends ToFloatFunction<C>> void validateSizes(float[] locations, List<CubicSpline<C, I>> values, float[] derivatives) {
            if (locations.length != values.size() || locations.length != derivatives.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + locations.length + " " + values.size() + " " + derivatives.length);
            }
            if (locations.length == 0) {
                throw new IllegalArgumentException("Cannot create a multipoint spline with no points");
            }
        }

        @Override
        @Override
        public float apply(C x) {
            float f = this.coordinate.apply(x);
            int i = Multipoint.findIntervalStart(this.locations, f);
            int j = this.locations.length - 1;
            if (i < 0) {
                return Multipoint.linearExtend(f, this.locations, this.values.get(0).apply(x), this.derivatives, 0);
            }
            if (i == j) {
                return Multipoint.linearExtend(f, this.locations, this.values.get(j).apply(x), this.derivatives, j);
            }
            float g = this.locations[i];
            float h = this.locations[i + 1];
            float k = (f - g) / (h - g);
            ToFloatFunction toFloatFunction = this.values.get(i);
            ToFloatFunction toFloatFunction2 = this.values.get(i + 1);
            float l = this.derivatives[i];
            float m = this.derivatives[i + 1];
            float n = toFloatFunction.apply(x);
            float o = toFloatFunction2.apply(x);
            float p = l * (h - g) - (o - n);
            float q = -m * (h - g) + (o - n);
            float r = Mth.lerp(k, n, o) + k * (1.0f - k) * Mth.lerp(k, p, q);
            return r;
        }

        private static int findIntervalStart(float[] locations, float x) {
            return Mth.binarySearch(0, locations.length, i -> x < locations[i]) - 1;
        }

        @Override
        @VisibleForTesting
        @Override
        public String parityString() {
            return "Spline{coordinate=" + String.valueOf(this.coordinate) + ", locations=" + this.toString(this.locations) + ", derivatives=" + this.toString(this.derivatives) + ", values=" + this.values.stream().map(CubicSpline::parityString).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String toString(float[] values) {
            return "[" + IntStream.range(0, values.length).mapToDouble(index -> values[index]).mapToObj(value -> String.format(Locale.ROOT, "%.3f", value)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> visitor) {
            return Multipoint.create((ToFloatFunction)visitor.visit(this.coordinate), this.locations, this.values().stream().map(value -> value.mapAll(visitor)).toList(), this.derivatives);
        }
    }

    public static interface CoordinateVisitor<I> {
        public I visit(I var1);
    }
}

