/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record TagKey<T>(ResourceKey<? extends Registry<T>> registry, ResourceLocation location) {
    private static final Interner<TagKey<?>> VALUES = Interners.newWeakInterner();

    public static <T> Codec<TagKey<T>> codec(ResourceKey<? extends Registry<T>> registry) {
        return ResourceLocation.CODEC.xmap(id -> TagKey.create(registry, id), TagKey::location);
    }

    public static <T> Codec<TagKey<T>> hashedCodec(ResourceKey<? extends Registry<T>> registry) {
        return Codec.STRING.comapFlatMap(string -> string.startsWith("#") ? ResourceLocation.read(string.substring(1)).map(id -> TagKey.create(registry, id)) : DataResult.error(() -> "Not a tag id"), string -> "#" + String.valueOf(string.location));
    }

    public static <T> TagKey<T> create(ResourceKey<? extends Registry<T>> registry, ResourceLocation id) {
        return (TagKey)VALUES.intern(new TagKey<T>(registry, id));
    }

    public boolean isFor(ResourceKey<? extends Registry<?>> registryRef) {
        return this.registry == registryRef;
    }

    public <E> Optional<TagKey<E>> cast(ResourceKey<? extends Registry<E>> registryRef) {
        return this.isFor(registryRef) ? Optional.of(this) : Optional.empty();
    }

    @Override
    @Override
    public String toString() {
        return "TagKey[" + String.valueOf(this.registry.location()) + " / " + String.valueOf(this.location) + "]";
    }
}

