/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.mojang.logging.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.rcon.PktUtils;
import net.minecraft.server.rcon.RconConsoleSource;
import net.minecraft.server.rcon.thread.GenericThread;
import org.slf4j.Logger;

public class RconClient
extends GenericThread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SERVERDATA_AUTH = 3;
    private static final int SERVERDATA_EXECCOMMAND = 2;
    private static final int SERVERDATA_RESPONSE_VALUE = 0;
    private static final int SERVERDATA_AUTH_RESPONSE = 2;
    private static final int SERVERDATA_AUTH_FAILURE = -1;
    private boolean authed;
    private final Socket client;
    private final byte[] buf = new byte[1460];
    private final String rconPassword;
    private final DedicatedServer serverInterface;
    private final RconConsoleSource rconConsoleSource;

    RconClient(ServerInterface server, String password, Socket socket) {
        super("RCON Client " + String.valueOf(socket.getInetAddress()));
        this.serverInterface = (DedicatedServer)server;
        this.client = socket;
        try {
            this.client.setSoTimeout(0);
        }
        catch (Exception exception) {
            this.running = false;
        }
        this.rconPassword = password;
        this.rconConsoleSource = new RconConsoleSource(this.serverInterface, socket.getRemoteSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block15: while (true) {
                if (!this.running) {
                    return;
                }
                BufferedInputStream bufferedinputstream = new BufferedInputStream(this.client.getInputStream());
                int i = bufferedinputstream.read(this.buf, 0, 1460);
                if (10 > i) {
                    return;
                }
                int j = 0;
                int k = PktUtils.intFromByteArray(this.buf, 0, i);
                if (k != i - 4) continue;
                int l = PktUtils.intFromByteArray(this.buf, j += 4, i);
                int i1 = PktUtils.intFromByteArray(this.buf, j += 4);
                j += 4;
                switch (i1) {
                    case 2: {
                        if (this.authed) {
                            String s = PktUtils.stringFromByteArray(this.buf, j, i);
                            try {
                                this.sendCmdResponse(l, this.serverInterface.runCommand(this.rconConsoleSource, s));
                            }
                            catch (Exception exception) {
                                this.sendCmdResponse(l, "Error executing: " + s + " (" + exception.getMessage() + ")");
                            }
                            continue block15;
                        }
                        this.sendAuthFailure();
                        continue block15;
                    }
                    case 3: {
                        String s1 = PktUtils.stringFromByteArray(this.buf, j, i);
                        int j1 = j + s1.length();
                        if (!s1.isEmpty() && s1.equals(this.rconPassword)) {
                            this.authed = true;
                            this.send(l, 2, "");
                            continue block15;
                        }
                        this.authed = false;
                        this.sendAuthFailure();
                        continue block15;
                    }
                }
                this.sendCmdResponse(l, String.format(Locale.ROOT, "Unknown request %s", Integer.toHexString(i1)));
                continue;
                break;
            }
        }
        catch (IOException ioexception) {
            return;
        }
        catch (Exception exception1) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)exception1);
            return;
        }
        finally {
            this.closeSocket();
            LOGGER.info("Thread {} shutting down", (Object)this.name);
            this.running = false;
        }
    }

    private void send(int sessionToken, int responseType, String message) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(1248);
        DataOutputStream dataoutputstream = new DataOutputStream(bytearrayoutputstream);
        byte[] abyte = message.getBytes(StandardCharsets.UTF_8);
        dataoutputstream.writeInt(Integer.reverseBytes(abyte.length + 10));
        dataoutputstream.writeInt(Integer.reverseBytes(sessionToken));
        dataoutputstream.writeInt(Integer.reverseBytes(responseType));
        dataoutputstream.write(abyte);
        dataoutputstream.write(0);
        dataoutputstream.write(0);
        this.client.getOutputStream().write(bytearrayoutputstream.toByteArray());
    }

    private void sendAuthFailure() throws IOException {
        this.send(-1, 2, "");
    }

    private void sendCmdResponse(int sessionToken, String message) throws IOException {
        int k;
        int j = message.length();
        do {
            k = 4096 <= j ? 4096 : j;
            this.send(sessionToken, 0, message.substring(0, k));
        } while (0 != (j = (message = message.substring(k)).length()));
    }

    @Override
    public void stop() {
        this.running = false;
        this.closeSocket();
        super.stop();
    }

    private void closeSocket() {
        try {
            this.client.close();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to close socket", (Throwable)ioexception);
        }
    }
}

