/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

@FunctionalInterface
public interface ResourceProvider {
    public static final ResourceProvider EMPTY = id -> Optional.empty();

    public Optional<Resource> getResource(ResourceLocation var1);

    default public Resource getResourceOrThrow(ResourceLocation id) throws FileNotFoundException {
        return this.getResource(id).orElseThrow(() -> new FileNotFoundException(id.toString()));
    }

    default public InputStream open(ResourceLocation id) throws IOException {
        return this.getResourceOrThrow(id).open();
    }

    default public BufferedReader openAsReader(ResourceLocation id) throws IOException {
        return this.getResourceOrThrow(id).openAsReader();
    }

    public static ResourceProvider fromMap(Map<ResourceLocation, Resource> map) {
        return id -> Optional.ofNullable((Resource)map.get(id));
    }
}

