/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;

public abstract class PackDetector<T> {
    private final DirectoryValidator validator;

    protected PackDetector(DirectoryValidator symlinkFinder) {
        this.validator = symlinkFinder;
    }

    @Nullable
    public T detectPackResources(Path path, List<ForbiddenSymlinkInfo> foundSymlinks) throws IOException {
        BasicFileAttributes basicFileAttributes2;
        Path path2 = path;
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (NoSuchFileException noSuchFileException) {
            return null;
        }
        if (basicFileAttributes2.isSymbolicLink()) {
            this.validator.validateSymlink(path, foundSymlinks);
            if (!foundSymlinks.isEmpty()) {
                return null;
            }
            path2 = Files.readSymbolicLink(path);
            basicFileAttributes2 = Files.readAttributes(path2, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        if (basicFileAttributes2.isDirectory()) {
            this.validator.validateKnownDirectory(path2, foundSymlinks);
            if (!foundSymlinks.isEmpty()) {
                return null;
            }
            if (!Files.isRegularFile(path2.resolve("pack.mcmeta"), new LinkOption[0])) {
                return null;
            }
            return this.createDirectoryPack(path2);
        }
        if (basicFileAttributes2.isRegularFile() && path2.getFileName().toString().endsWith(".zip")) {
            return this.createZipPack(path2);
        }
        return null;
    }

    @Nullable
    protected abstract T createZipPack(Path var1) throws IOException;

    @Nullable
    protected abstract T createDirectoryPack(Path var1) throws IOException;
}

