/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class PathPackResources
extends AbstractPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;

    public PathPackResources(PackLocationInfo info, Path root) {
        super(info);
        this.root = root;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... segments) {
        FileUtil.validatePath(segments);
        Path path = FileUtil.resolvePath(this.root, List.of(segments));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create(path) : null;
    }

    public static boolean validatePath(Path path) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(PackType type, ResourceLocation id) {
        Path path = this.root.resolve(type.getDirectory()).resolve(id.getNamespace());
        return PathPackResources.getResource(id, path);
    }

    @Nullable
    public static IoSupplier<InputStream> getResource(ResourceLocation id, Path path) {
        return (IoSupplier)FileUtil.decomposePath(id.getPath()).mapOrElse(segments -> {
            Path path2 = FileUtil.resolvePath(path, segments);
            return PathPackResources.returnFileIfExists(path2);
        }, error -> {
            LOGGER.error("Invalid path {}: {}", (Object)id, (Object)error.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path path) {
        return Files.exists(path, new LinkOption[0]) && PathPackResources.validatePath(path) ? IoSupplier.create(path) : null;
    }

    @Override
    public void listResources(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        FileUtil.decomposePath(prefix).ifSuccess(prefixSegments -> {
            Path path = this.root.resolve(type.getDirectory()).resolve(namespace);
            PathPackResources.listPath(namespace, path, prefixSegments, consumer);
        }).ifError(error -> LOGGER.error("Invalid path {}: {}", (Object)prefix, (Object)error.message()));
    }

    public static void listPath(String namespace, Path path, List<String> prefixSegments, PackResources.ResourceOutput consumer) {
        Path path2 = FileUtil.resolvePath(path, prefixSegments);
        try (Stream<Path> stream2 = Files.find(path2, Integer.MAX_VALUE, (path2x, attributes) -> attributes.isRegularFile(), new FileVisitOption[0]);){
            stream2.forEach(foundPath -> {
                String string2 = PATH_JOINER.join((Iterable)path.relativize((Path)foundPath));
                ResourceLocation resourceLocation = ResourceLocation.tryBuild(namespace, string2);
                if (resourceLocation == null) {
                    Util.logAndPauseIfInIde(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", namespace, string2));
                } else {
                    consumer.accept(resourceLocation, IoSupplier.create(foundPath));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException stream2) {
        }
        catch (IOException var11) {
            LOGGER.error("Failed to list path {}", (Object)path2, (Object)var11);
        }
    }

    @Override
    public Set<String> getNamespaces(PackType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.root.resolve(type.getDirectory());
        try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream2) {
                String string = path2.getFileName().toString();
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    LOGGER.error("Invalid directory entry: {} in {}.", new Object[]{string, this.root, new NotDirectoryException(string)});
                    continue;
                }
                if (ResourceLocation.isValidNamespace(string)) {
                    set.add(string);
                    continue;
                }
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string, (Object)this.root);
            }
        }
        catch (NoSuchFileException | NotDirectoryException directoryStream2) {
        }
        catch (IOException var11) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)var11);
        }
        return set;
    }

    @Override
    public void close() {
    }

    public static class PathResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final Path content;

        public PathResourcesSupplier(Path path) {
            this.content = path;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo info) {
            return new PathPackResources(info, this.content);
        }

        @Override
        public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
            PackResources packResources = this.openPrimary(info);
            List<String> list = metadata.overlays();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<PackResources> list2 = new ArrayList<PackResources>(list.size());
            for (String string : list) {
                Path path = this.content.resolve(string);
                list2.add(new PathPackResources(info, path));
            }
            return new CompositePackResources(packResources, list2);
        }
    }
}

