/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.level.ChunkPos;

public class TickingTracker
extends ChunkTracker {
    public static final int MAX_LEVEL = 33;
    private static final int INITIAL_TICKET_LIST_CAPACITY = 4;
    protected final Long2ByteMap chunks = new Long2ByteOpenHashMap();
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets = new Long2ObjectOpenHashMap();

    public TickingTracker() {
        super(34, 16, 256);
        this.chunks.defaultReturnValue((byte)33);
    }

    private SortedArraySet<Ticket<?>> getTickets(long pos) {
        return (SortedArraySet)this.tickets.computeIfAbsent(pos, p -> SortedArraySet.create(4));
    }

    private int getTicketLevelAt(SortedArraySet<Ticket<?>> ticket) {
        return ticket.isEmpty() ? 34 : ticket.first().getTicketLevel();
    }

    public void addTicket(long pos, Ticket<?> ticket) {
        SortedArraySet<Ticket<?>> sortedArraySet = this.getTickets(pos);
        int i = this.getTicketLevelAt(sortedArraySet);
        sortedArraySet.add(ticket);
        if (ticket.getTicketLevel() < i) {
            this.update(pos, ticket.getTicketLevel(), true);
        }
    }

    public void removeTicket(long pos, Ticket<?> ticket) {
        SortedArraySet<Ticket<?>> sortedArraySet = this.getTickets(pos);
        sortedArraySet.remove(ticket);
        if (sortedArraySet.isEmpty()) {
            this.tickets.remove(pos);
        }
        this.update(pos, this.getTicketLevelAt(sortedArraySet), false);
    }

    public <T> void addTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        this.addTicket(pos.toLong(), new Ticket<T>(type, level, argument));
    }

    public <T> void removeTicket(TicketType<T> type, ChunkPos pos, int level, T argument) {
        Ticket<T> ticket = new Ticket<T>(type, level, argument);
        this.removeTicket(pos.toLong(), ticket);
    }

    public void replacePlayerTicketsLevel(int level) {
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (Long2ObjectMap.Entry entry : this.tickets.long2ObjectEntrySet()) {
            for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                if (ticket.getType() != TicketType.PLAYER) continue;
                list.add(Pair.of((Object)ticket, (Object)entry.getLongKey()));
            }
        }
        for (Pair pair : list) {
            Long long_ = (Long)pair.getSecond();
            Ticket ticket2 = (Ticket)pair.getFirst();
            this.removeTicket(long_, ticket2);
            ChunkPos chunkPos = new ChunkPos(long_);
            TicketType ticketType = ticket2.getType();
            this.addTicket(ticketType, chunkPos, level, chunkPos);
        }
    }

    @Override
    @Override
    protected int getLevelFromSource(long id) {
        SortedArraySet sortedArraySet = (SortedArraySet)this.tickets.get(id);
        if (sortedArraySet == null || sortedArraySet.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        return ((Ticket)sortedArraySet.first()).getTicketLevel();
    }

    public int getLevel(ChunkPos pos) {
        return this.getLevel(pos.toLong());
    }

    @Override
    @Override
    protected int getLevel(long id) {
        return this.chunks.get(id);
    }

    @Override
    @Override
    protected void setLevel(long id, int level) {
        if (level >= 33) {
            this.chunks.remove(id);
        } else {
            this.chunks.put(id, (byte)level);
        }
    }

    public void runAllUpdates() {
        this.runUpdates(Integer.MAX_VALUE);
    }

    public String getTicketDebugString(long pos) {
        SortedArraySet sortedArraySet = (SortedArraySet)this.tickets.get(pos);
        if (sortedArraySet == null || sortedArraySet.isEmpty()) {
            return "no_ticket";
        }
        return ((Ticket)sortedArraySet.first()).toString();
    }
}

