/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerClosePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class ServerPlayerGameMode {
    private static final Logger LOGGER = LogUtils.getLogger();
    public ServerLevel level;
    protected final ServerPlayer player;
    private GameType gameModeForPlayer = GameType.DEFAULT_MODE;
    @Nullable
    private GameType previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;
    public boolean captureSentBlockEntities = false;
    public boolean capturedBlockEntity = false;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPos interactPosition;
    public InteractionHand interactHand;
    public ItemStack interactItemStack;

    public ServerPlayerGameMode(ServerPlayer player) {
        this.player = player;
        this.level = player.serverLevel();
    }

    public boolean changeGameModeForPlayer(GameType gameMode) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent changeGameModeForPlayer(GameType gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component cancelMessage) {
        if (gameMode == this.gameModeForPlayer) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.player.getBukkitEntity(), GameMode.getByValue((int)gameMode.getId()), cause, cancelMessage);
        this.level.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.setGameModeForPlayer(gameMode, this.gameModeForPlayer);
        this.player.onUpdateAbilities();
        this.player.server.getPlayerList().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_GAME_MODE, this.player), this.player);
        this.level.updateSleepingPlayerList();
        if (gameMode == GameType.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return event;
    }

    protected void setGameModeForPlayer(GameType gameMode, @Nullable GameType previousGameMode) {
        this.previousGameModeForPlayer = previousGameMode;
        this.gameModeForPlayer = gameMode;
        gameMode.updatePlayerAbilities(this.player.getAbilities());
    }

    public GameType getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    @Nullable
    public GameType getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        this.gameTicks = MinecraftServer.currentTick;
        if (this.hasDelayedDestroy) {
            net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockStateIfLoaded(this.delayedDestroyPos);
            if (iblockdata == null || iblockdata.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float f = this.incrementDestroyProgress(iblockdata, this.delayedDestroyPos, this.delayedTickStart);
                if (f >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockStateIfLoaded(this.destroyPos);
            if (iblockdata == null) {
                this.isDestroyingBlock = false;
                return;
            }
            if (iblockdata.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress(iblockdata, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(net.minecraft.world.level.block.state.BlockState state, BlockPos pos, int failedStartMiningTime) {
        int j = this.gameTicks - failedStartMiningTime;
        float f = state.getDestroyProgress(this.player, this.player.level(), pos) * (float)(j + 1);
        int k = (int)(f * 10.0f);
        if (k != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), pos, k);
            this.lastSentState = k;
        }
        return f;
    }

    private void debugLogging(BlockPos pos, boolean success, int sequence, String reason) {
    }

    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int worldHeight, int sequence) {
        if (!this.player.canInteractWithBlock(pos, 1.0)) {
            return;
        }
        if (pos.getY() >= worldHeight) {
            this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, pos, direction, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
                this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "may not interact");
                this.capturedBlockEntity = true;
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.player, Action.LEFT_CLICK_BLOCK, pos, direction, this.player.getInventory().getSelected(), InteractionHand.MAIN_HAND);
            if (event.isCancelled()) {
                this.capturedBlockEntity = true;
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(pos, sequence, "creative destroy");
                return;
            }
            if (this.player.getMainHandItem().is(Items.DEBUG_STICK) && ((DebugStickItem)Items.DEBUG_STICK).handleInteraction(this.player, this.level.getBlockState(pos), this.level, pos, false, this.player.getMainHandItem())) {
                return;
            }
            if (this.player.blockActionRestricted(this.level, pos, this.gameModeForPlayer)) {
                this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f = 1.0f;
            net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(pos);
            if (event.useInteractedBlock() != Event.Result.DENY && !iblockdata.isAir()) {
                EnchantmentHelper.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EquipmentSlot.MAINHAND, Vec3.atCenterOf(pos), iblockdata, item -> this.player.onEquippedItemBroken((Item)item, EquipmentSlot.MAINHAND));
                iblockdata.attack(this.level, pos, this.player);
                f = iblockdata.getDestroyProgress(this.player, this.player.level(), pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f > 1.0f) {
                    // empty if block
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.player, pos, direction, this.player.getInventory().getSelected(), f >= 1.0f);
            if (blockEvent.isCancelled()) {
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f = 2.0f;
            }
            if (!iblockdata.isAir() && f >= 1.0f) {
                this.destroyAndAck(pos, sequence, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new ClientboundBlockUpdatePacket(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = pos.immutable();
                int k = (int)(f * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), pos, k);
                this.debugLogging(pos, true, sequence, "actual start of destroying");
                this.lastSentState = k;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals(this.destroyPos)) {
                int l = this.gameTicks - this.destroyProgressStart;
                net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(pos);
                if (!iblockdata.isAir()) {
                    float f1 = iblockdata.getDestroyProgress(this.player, this.player.level(), pos) * (float)(l + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), pos, -1);
                        this.destroyAndAck(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = pos;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(pos, true, sequence, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, pos) && !BlockPos.ZERO.equals(this.destroyPos)) {
                LOGGER.debug("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)pos);
                net.minecraft.world.level.block.state.BlockState type = this.level.getBlockStateIfLoaded(this.destroyPos);
                if (type != null) {
                    this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                }
                if (type != null) {
                    this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
                }
                this.destroyPos = BlockPos.ZERO;
            }
            this.level.destroyBlockProgress(this.player.getId(), pos, -1);
            this.debugLogging(pos, true, sequence, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.player, pos, this.player.getInventory().getSelected());
        }
        this.level.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, direction, worldHeight, sequence);
    }

    public void destroyAndAck(BlockPos pos, int sequence, String reason) {
        if (this.destroyBlock(pos)) {
            this.debugLogging(pos, true, sequence, reason);
        } else {
            this.player.connection.send(new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, reason);
        }
    }

    public boolean destroyBlock(BlockPos pos) {
        net.minecraft.world.level.block.state.BlockState iblockdata = this.level.getBlockState(pos);
        CraftBlock bblock = CraftBlock.at(this.level, pos);
        BlockBreakEvent event = null;
        if (this.player instanceof ServerPlayer) {
            boolean isSwordNoBreak = !this.player.getMainHandItem().getItem().canAttackBlock(iblockdata, this.level, pos, this.player);
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.player.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            net.minecraft.world.level.block.state.BlockState nmsData = this.level.getBlockState(pos);
            Block nmsBlock = nmsData.getBlock();
            ItemStack itemstack = this.player.getItemBySlot(EquipmentSlot.MAINHAND);
            if (nmsBlock != null && !event.isCancelled() && !this.isCreative() && this.player.hasCorrectToolForDrops(nmsBlock.defaultBlockState())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.level, pos, itemstack, true));
            }
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                if (!this.captureSentBlockEntities) {
                    BlockEntity tileentity = this.level.getBlockEntity(pos);
                    if (tileentity != null) {
                        this.player.connection.send(tileentity.getUpdatePacket());
                    }
                } else {
                    this.capturedBlockEntity = true;
                }
                return false;
            }
        }
        if ((iblockdata = this.level.getBlockState(pos)).isAir()) {
            return false;
        }
        BlockEntity tileentity = this.level.getBlockEntity(pos);
        Block block = iblockdata.getBlock();
        if (!(!(block instanceof GameMasterBlock) || this.player.canUseGameMasterBlocks() || block instanceof CommandBlock && this.player.isCreative() && this.player.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.level.sendBlockUpdated(pos, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, pos, this.gameModeForPlayer)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.level.captureDrops = new ArrayList<ItemEntity>();
        net.minecraft.world.level.block.state.BlockState iblockdata1 = block.playerWillDestroy(this.level, pos, iblockdata, this.player);
        boolean flag = this.level.removeBlock(pos, false);
        if (flag) {
            block.destroy(this.level, pos, iblockdata1);
        }
        ItemStack mainHandStack = null;
        boolean isCorrectTool = false;
        if (!this.isCreative()) {
            ItemStack itemstack = this.player.getMainHandItem();
            ItemStack itemstack1 = itemstack.copy();
            boolean flag1 = this.player.hasCorrectToolForDrops(iblockdata1);
            mainHandStack = itemstack1;
            isCorrectTool = flag1;
            itemstack.mineBlock(this.level, iblockdata1, pos, this.player);
            if (flag && flag1) {
                block.playerDestroy(this.level, this.player, pos, iblockdata1, tileentity, itemstack1, event.isDropItems(), false);
            }
        }
        List<ItemEntity> itemsToDrop = this.level.captureDrops;
        this.level.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.player, itemsToDrop);
        }
        if (flag && event != null) {
            iblockdata.getBlock().popExperience(this.level, pos, event.getExpToDrop(), this.player);
        }
        if (mainHandStack != null && flag && isCorrectTool && event.isDropItems() && block instanceof BeehiveBlock && tileentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)tileentity;
            CriteriaTriggers.BEE_NEST_DESTROYED.trigger(this.player, iblockdata, mainHandStack, beehiveBlockEntity.getOccupantCount());
        }
        return true;
    }

    public InteractionResult useItem(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand) {
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            return InteractionResult.PASS;
        }
        int i = stack.getCount();
        int j = stack.getDamageValue();
        InteractionResultHolder<ItemStack> interactionresultwrapper = stack.use(world, player, hand);
        ItemStack itemstack1 = interactionresultwrapper.getObject();
        if (itemstack1 == stack && itemstack1.getCount() == i && itemstack1.getUseDuration(player) <= 0 && itemstack1.getDamageValue() == j) {
            return interactionresultwrapper.getResult();
        }
        if (interactionresultwrapper.getResult() == InteractionResult.FAIL && itemstack1.getUseDuration(player) > 0 && !player.isUsingItem()) {
            return interactionresultwrapper.getResult();
        }
        if (stack != itemstack1) {
            player.setItemInHand(hand, itemstack1);
        }
        if (itemstack1.isEmpty()) {
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
        if (!player.isUsingItem()) {
            player.inventoryMenu.sendAllDataToRemote();
        }
        return interactionresultwrapper.getResult();
    }

    public InteractionResult useItemOn(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult enuminteractionresult;
        BlockPos blockposition = hitResult.getBlockPos();
        net.minecraft.world.level.block.state.BlockState iblockdata = world.getBlockState(blockposition);
        boolean cancelledBlock = false;
        boolean cancelledItem = false;
        if (!iblockdata.getBlock().isEnabled(world.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider itileinventory = iblockdata.getMenuProvider(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof MenuProvider);
        }
        if (player.getCooldowns().isOnCooldown(stack.getItem())) {
            cancelledItem = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockposition, hitResult.getDirection(), stack, cancelledBlock, cancelledItem, hand, hitResult.getLocation());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.immutable();
        this.interactHand = hand;
        this.interactItemStack = stack.copy();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (!(iblockdata.getBlock() instanceof DoorBlock)) {
                if (iblockdata.getBlock() instanceof CakeBlock) {
                    player.getBukkitEntity().sendHealthUpdate();
                } else if (!(this.interactItemStack.getItem() instanceof DoubleHighBlockItem) && (iblockdata.is(Blocks.JIGSAW) || iblockdata.is(Blocks.STRUCTURE_BLOCK) || iblockdata.getBlock() instanceof CommandBlock)) {
                    player.connection.send(new ClientboundContainerClosePacket(this.player.containerMenu.containerId));
                }
            }
            player.getBukkitEntity().updateInventory();
            this.player.resyncUsingItem(this.player);
            return event.useItemInHand() != Event.Result.ALLOW ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (this.gameModeForPlayer == GameType.SPECTATOR) {
            MenuProvider itileinventory = iblockdata.getMenuProvider(world, blockposition);
            if (itileinventory != null) {
                player.openMenu(itileinventory);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean flag = !player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty();
        boolean flag1 = player.isSecondaryUseActive() && flag;
        ItemStack itemstack1 = stack.copy();
        if (!flag1) {
            ItemInteractionResult iteminteractionresult = iblockdata.useItemOn(player.getItemInHand(hand), world, player, hand, hitResult);
            if (iteminteractionresult.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, blockposition, itemstack1);
                return iteminteractionresult.result();
            }
            if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && hand == InteractionHand.MAIN_HAND && (enuminteractionresult = iblockdata.useWithoutItem(world, player, hitResult)).consumesAction()) {
                CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(player, blockposition);
                return enuminteractionresult;
            }
        }
        if (!stack.isEmpty() && !this.interactResult) {
            UseOnContext itemactioncontext = new UseOnContext(player, hand, hitResult);
            if (this.isCreative()) {
                int i = stack.getCount();
                enuminteractionresult = stack.useOn(itemactioncontext);
                stack.setCount(i);
            } else {
                enuminteractionresult = stack.useOn(itemactioncontext);
            }
            if (enuminteractionresult.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(player, blockposition, itemstack1);
            }
            return enuminteractionresult;
        }
        if (this.interactResult && this.interactResult != cancelledItem) {
            this.player.resyncUsingItem(this.player);
        }
        return InteractionResult.PASS;
    }

    public void setLevel(ServerLevel world) {
        this.level = world;
    }
}

