/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemServerChunkCache;
import co.aikar.timings.Timing;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ServerChunkCache
extends ChunkSource
implements ChunkSystemServerChunkCache {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final DistanceManager distanceManager;
    final ServerLevel level;
    public final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    public final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;
    public final IteratorSafeOrderedReferenceSet<LevelChunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    public final IteratorSafeOrderedReferenceSet<LevelChunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    private final ConcurrentLong2ReferenceChainedHashTable<LevelChunk> fullChunks = new ConcurrentLong2ReferenceChainedHashTable();
    long chunkFutureAwaitCounter;

    @Override
    public final void moonrise$setFullChunk(int chunkX, int chunkZ, LevelChunk chunk) {
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        if (chunk == null) {
            this.fullChunks.remove(key);
        } else {
            this.fullChunks.put(key, chunk);
        }
    }

    @Override
    public final LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return this.fullChunks.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    private ChunkAccess syncLoad(int chunkX, int chunkZ, ChunkStatus toStatus) {
        ChunkAccess ret;
        ChunkTaskScheduler chunkTaskScheduler = this.level.moonrise$getChunkTaskScheduler();
        CompletableFuture completable = new CompletableFuture();
        chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, toStatus, true, PrioritisedExecutor.Priority.BLOCKING, completable::complete);
        if (TickThread.isTickThreadFor(this.level, chunkX, chunkZ)) {
            ChunkTaskScheduler.pushChunkWait(this.level, chunkX, chunkZ);
            this.mainThreadProcessor.managedBlock(completable::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ret = (ChunkAccess)completable.join()) == null) {
            throw new IllegalStateException("Chunk not loaded when requested");
        }
        return ret;
    }

    private ChunkAccess getChunkFallback(int chunkX, int chunkZ, ChunkStatus toStatus, boolean load) {
        ChunkAccess ifPresent;
        ChunkTaskScheduler chunkTaskScheduler = this.level.moonrise$getChunkTaskScheduler();
        ChunkHolderManager chunkHolderManager = chunkTaskScheduler.chunkHolderManager;
        NewChunkHolder currentChunk = chunkHolderManager.getChunkHolder(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkAccess chunkAccess = ifPresent = currentChunk == null ? null : currentChunk.getChunkIfPresent(toStatus);
        if (ifPresent != null && (toStatus != ChunkStatus.FULL || currentChunk.isFullChunkReady())) {
            return ifPresent;
        }
        return load ? this.syncLoad(chunkX, chunkZ, toStatus) : null;
    }

    public ServerChunkCache(ServerLevel world, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, ChunkProgressListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<DimensionDataStorage> persistentStateManagerFactory) {
        this.level = world;
        this.mainThreadProcessor = new MainThreadExecutor(world);
        this.mainThread = Thread.currentThread();
        File file = session.getDimensionPath(world.dimension()).resolve("data").toFile();
        file.mkdirs();
        this.dataStorage = new DimensionDataStorage(file, dataFixer, world.registryAccess());
        this.chunkMap = new ChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.mainThreadProcessor, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(simulationDistance);
        this.clearCache();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = this.chunkMap.getUpdatingChunkIfPresent(ChunkPos.asLong(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    @Nullable
    public ChunkAccess getChunkAtImmediately(int x, int z) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong(x, z));
        if (holder == null) {
            return null;
        }
        return holder.getLatestChunk();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.addTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.removeTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public LevelChunk getChunkAtIfCachedImmediately(int x, int z) {
        long k = ChunkPos.asLong(x, z);
        ChunkHolder playerChunk = this.getVisibleChunkIfPresent(k);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public LevelChunk getChunkAtIfLoadedImmediately(int x, int z) {
        return this.fullChunks.get(ChunkPos.asLong(x, z));
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long pos) {
        return this.chunkMap.getVisibleChunkIfPresent(pos);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long pos, @Nullable ChunkAccess chunk, ChunkStatus status) {
        for (int j = 3; j > 0; --j) {
            this.lastChunkPos[j] = this.lastChunkPos[j - 1];
            this.lastChunkStatus[j] = this.lastChunkStatus[j - 1];
            this.lastChunk[j] = this.lastChunk[j - 1];
        }
        this.lastChunkPos[0] = pos;
        this.lastChunkStatus[0] = status;
        this.lastChunk[0] = chunk;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus leastStatus, boolean create) {
        if (leastStatus == ChunkStatus.FULL) {
            LevelChunk ret = this.fullChunks.get(CoordinateUtils.getChunkKey(x, z));
            if (ret != null) {
                return ret;
            }
            return create ? this.getChunkFallback(x, z, leastStatus, create) : null;
        }
        return this.getChunkFallback(x, z, leastStatus, create);
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int chunkX, int chunkZ) {
        return this.level.moonrise$getFullChunkIfLoaded(chunkX, chunkZ);
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<ChunkResult<ChunkAccess>> completablefuture;
        boolean flag1;
        boolean bl = flag1 = Thread.currentThread() == this.mainThread;
        if (flag1) {
            completablefuture = this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create);
            MainThreadExecutor chunkproviderserver_b = this.mainThreadProcessor;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.managedBlock(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create), this.mainThreadProcessor).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        ChunkAccess ifPresent;
        boolean needsFullScheduling;
        TickThread.ensureTickThread(this.level, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.byStatus(leastStatus);
        NewChunkHolder chunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.FULL && (chunkHolder == null || !chunkHolder.getChunkStatus().isOrAfter(FullChunkStatus.FULL));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return GenerationChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        ChunkAccess chunkAccess = ifPresent = chunkHolder == null ? null : chunkHolder.getChunkIfPresent(leastStatus);
        if (needsFullScheduling || ifPresent == null) {
            CompletableFuture<ChunkResult<ChunkAccess>> ret = new CompletableFuture<ChunkResult<ChunkAccess>>();
            Consumer<ChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(GenerationChunkHolder.UNLOADED_CHUNK);
                } else {
                    ret.complete(ChunkResult.of(chunk));
                }
            };
            this.level.moonrise$getChunkTaskScheduler().scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, PrioritisedExecutor.Priority.HIGHER, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.of(ifPresent));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.getChunkNow(x, z) != null;
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int chunkX, int chunkZ) {
        NewChunkHolder newChunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        if (newChunkHolder == null) {
            return null;
        }
        return newChunkHolder.getChunkIfPresentUnchecked(ChunkStatus.INITIALIZE_LIGHT.getParent());
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    public boolean runDistanceManagerUpdates() {
        return this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(Entity entity) {
        return this.isPositionTicking(ChunkPos.asLong(Mth.floor(entity.getX()) >> 4, Mth.floor(entity.getZ()) >> 4));
    }

    public boolean isPositionTicking(long pos) {
        NewChunkHolder newChunkHolder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return newChunkHolder != null && newChunkHolder.isTickingReady();
    }

    public void save(boolean flush) {
        try (Timing timed = this.level.timings.chunkSaveData.startTiming();){
            this.chunkMap.saveAllChunks(flush);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) throws IOException {
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.close(save, true);
    }

    public void purgeUnload() {
        this.level.getProfiler().push("purge");
        this.distanceManager.purgeStaleTickets();
        this.runDistanceManagerUpdates();
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(() -> true);
        this.level.getProfiler().pop();
        this.clearCache();
    }

    @Override
    public void tick(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.level.getProfiler().push("purge");
        this.level.timings.doChunkMap.startTiming();
        if (this.level.tickRateManager().runsNormally() || !tickChunks || this.level.spigotConfig.unloadFrozenChunks) {
            this.distanceManager.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        this.level.timings.doChunkMap.stopTiming();
        this.level.getProfiler().popPush("chunks");
        if (tickChunks) {
            this.level.timings.chunks.startTiming();
            this.level.moonrise$getPlayerChunkLoader().tick();
            this.tickChunks();
            this.level.timings.chunks.stopTiming();
            this.chunkMap.tick();
        }
        this.level.timings.doChunkUnload.startTiming();
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(shouldKeepTicking);
        this.level.timings.doChunkUnload.stopTiming();
        this.level.getProfiler().pop();
        this.clearCache();
    }

    private void tickChunks() {
        long i = this.level.getGameTime();
        long j = i - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = i;
        if (!this.level.isDebug()) {
            ProfilerFiller gameprofilerfiller = this.level.getProfiler();
            gameprofilerfiller.push("pollingChunks");
            gameprofilerfiller.push("filteringLoadedChunks");
            ArrayList list = Lists.newArrayListWithCapacity((int)this.chunkMap.size());
            Iterator<ChunkHolder> iterator = this.chunkMap.getChunks().iterator();
            if (this.level.getServer().tickRateManager().runsNormally()) {
                this.level.timings.chunkTicks.startTiming();
            }
            while (iterator.hasNext()) {
                ChunkHolder playerchunk = iterator.next();
                LevelChunk chunk = playerchunk.getTickingChunk();
                if (chunk == null) continue;
                list.add(new ChunkAndHolder(chunk, playerchunk));
            }
            if (this.level.tickRateManager().runsNormally()) {
                NaturalSpawner.SpawnState spawnercreature_d;
                int k;
                gameprofilerfiller.popPush("naturalSpawnCount");
                this.level.timings.countNaturalMobs.startTiming();
                int naturalSpawnChunkCount = k = this.distanceManager.getNaturalSpawnChunkCount();
                if ((this.spawnFriendlies || this.spawnEnemies) && this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    for (ServerPlayer player : this.level.players) {
                        for (int ii = 0; ii < ServerPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                            player.mobCounts[ii] = 0;
                            int newBackoff = player.mobBackoffCounts[ii] - 1;
                            if (newBackoff < 0) {
                                newBackoff = 0;
                            }
                            player.mobBackoffCounts[ii] = newBackoff;
                        }
                    }
                    spawnercreature_d = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, null, true);
                } else {
                    spawnercreature_d = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, !this.level.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.chunkMap) : null, false);
                }
                this.level.timings.countNaturalMobs.stopTiming();
                this.lastSpawnState = spawnercreature_d;
                gameprofilerfiller.popPush("spawnAndTick");
                boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && !this.level.players().isEmpty();
                Util.shuffle(list, this.level.random);
                int chunkRange = this.level.spigotConfig.mobSpawnRange;
                chunkRange = chunkRange > this.level.spigotConfig.viewDistance ? (int)this.level.spigotConfig.viewDistance : chunkRange;
                chunkRange = Math.min(chunkRange, 8);
                for (ServerPlayer entityPlayer : this.level.players()) {
                    entityPlayer.playerNaturallySpawnedEvent = new PlayerNaturallySpawnCreaturesEvent((Player)entityPlayer.getBukkitEntity(), (byte)chunkRange);
                    entityPlayer.playerNaturallySpawnedEvent.callEvent();
                }
                int l = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
                boolean flag1 = this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.level.getLevelData().getGameTime() % this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
                for (ChunkAndHolder chunkproviderserver_a : list) {
                    LevelChunk chunk1 = chunkproviderserver_a.chunk;
                    ChunkPos chunkcoordintpair = chunk1.getPos();
                    if (!this.level.isNaturalSpawningAllowed(chunkcoordintpair) || !this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair)) continue;
                    chunk1.incrementInhabitedTime(j);
                    if (flag && (this.spawnEnemies || this.spawnFriendlies) && this.level.getWorldBorder().isWithinBounds(chunkcoordintpair) && this.chunkMap.anyPlayerCloseEnoughForSpawning(chunkcoordintpair, true)) {
                        NaturalSpawner.spawnForChunk(this.level, chunk1, spawnercreature_d, this.spawnFriendlies, this.spawnEnemies, flag1);
                    }
                    if (!this.level.shouldTickBlocksAt(chunkcoordintpair.toLong())) continue;
                    this.level.tickChunk(chunk1, l);
                }
                this.level.timings.chunkTicks.stopTiming();
                gameprofilerfiller.popPush("customSpawners");
                if (flag) {
                    try (Timing ignored = this.level.timings.miscMobSpawning.startTiming();){
                        this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
                    }
                }
            }
            gameprofilerfiller.popPush("broadcast");
            list.forEach(chunkproviderserver_a1 -> {
                this.level.timings.broadcastChunkUpdates.startTiming();
                chunkproviderserver_a1.holder.broadcastChanges(chunkproviderserver_a1.chunk);
                this.level.timings.broadcastChunkUpdates.stopTiming();
            });
            gameprofilerfiller.pop();
            gameprofilerfiller.pop();
        }
    }

    private void getFullChunk(long pos, Consumer<LevelChunk> chunkConsumer) {
        LevelChunk fullChunk = this.getChunkNow(CoordinateUtils.getChunkX(pos), CoordinateUtils.getChunkZ(pos));
        if (fullChunk != null) {
            chunkConsumer.accept(fullChunk);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos pos) {
        int j;
        int i = SectionPos.blockToSectionCoord(pos.getX());
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(ChunkPos.asLong(i, j = SectionPos.blockToSectionCoord(pos.getZ())));
        if (playerchunk != null) {
            playerchunk.blockChanged(pos);
        }
    }

    @Override
    public void onLightUpdate(LightLayer type, SectionPos pos) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos.chunk().toLong());
            if (playerchunk != null) {
                playerchunk.sectionLightChanged(type, pos.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.addRegionTicket(ticketType, pos, radius, argument);
    }

    public <T> void removeRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.removeRegionTicket(ticketType, pos, radius, argument);
    }

    @Override
    public void updateChunkForced(ChunkPos pos, boolean forced) {
        this.distanceManager.updateChunkForced(pos, forced);
    }

    public void move(ServerPlayer player) {
        if (!player.isRemoved()) {
            this.chunkMap.move(player);
        }
    }

    public void removeEntity(Entity entity) {
        this.chunkMap.removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        this.chunkMap.addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcast(entity, packet);
    }

    public void setViewDistance(int watchDistance) {
        this.chunkMap.setServerViewDistance(watchDistance);
    }

    public void setSendViewDistance(int viewDistance) {
        this.level.moonrise$getPlayerChunkLoader().setSendDistance(viewDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        this.distanceManager.updateSimulationDistance(simulationDistance);
    }

    @Override
    public void setSpawnSettings(boolean spawnMonsters, boolean spawnAnimals) {
        this.spawnEnemies = spawnMonsters;
        this.spawnFriendlies = spawnAnimals;
    }

    public String getChunkDebugData(ChunkPos pos) {
        return this.chunkMap.getChunkDebugData(pos);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    public final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level world) {
            super("Chunk source main thread executor for " + String.valueOf(world.dimension().location()));
        }

        @Override
        public void managedBlock(BooleanSupplier stopCondition) {
            super.managedBlock(() -> MinecraftServer.throwIfFatalException() && stopCondition.getAsBoolean());
        }

        @Override
        protected Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean shouldRun(Runnable task) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable task) {
            ServerChunkCache.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(task);
        }

        @Override
        public boolean pollTask() {
            ServerChunkCache serverChunkCache = ServerChunkCache.this;
            if (serverChunkCache.runDistanceManagerUpdates()) {
                return true;
            }
            return super.pollTask() | serverChunkCache.level.moonrise$getChunkTaskScheduler().executeMainThreadTask();
        }
    }

    private record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

