/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.core.SectionPos;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;

public abstract class SectionTracker
extends DynamicGraphMinFixedPoint {
    protected SectionTracker(int levelCount, int expectedLevelSize, int expectedTotalSize) {
        super(levelCount, expectedLevelSize, expectedTotalSize);
    }

    @Override
    @Override
    protected void checkNeighborsAfterUpdate(long id, int level, boolean decrease) {
        if (decrease && level >= this.levelCount - 2) {
            return;
        }
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    long l = SectionPos.offset(id, i, j, k);
                    if (l == id) continue;
                    this.checkNeighbor(id, l, level, decrease);
                }
            }
        }
    }

    @Override
    @Override
    protected int getComputedLevel(long id, long excludedId, int maxLevel) {
        int i = maxLevel;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                for (int l = -1; l <= 1; ++l) {
                    long m = SectionPos.offset(id, j, k, l);
                    if (m == id) {
                        m = Long.MAX_VALUE;
                    }
                    if (m == excludedId) continue;
                    int n = this.computeLevelFromNeighbor(m, id, this.getLevel(m));
                    if (i > n) {
                        i = n;
                    }
                    if (i != 0) continue;
                    return i;
                }
            }
        }
        return i;
    }

    @Override
    @Override
    protected int computeLevelFromNeighbor(long sourceId, long targetId, int level) {
        if (this.isSource(sourceId)) {
            return this.getLevelFromSource(targetId);
        }
        return level + 1;
    }

    protected abstract int getLevelFromSource(long var1);

    public void update(long id, int level, boolean decrease) {
        this.checkEdge(Long.MAX_VALUE, id, level, decrease);
    }
}

