/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;

public abstract class GenerationChunkHolder {
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private static final ChunkResult<ChunkAccess> NOT_DONE_YET = ChunkResult.error("Not done yet");
    public static final ChunkResult<ChunkAccess> UNLOADED_CHUNK = ChunkResult.error("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<ChunkAccess>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    protected final ChunkPos pos;

    public GenerationChunkHolder(ChunkPos pos) {
        this.pos = pos;
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkGenerationTask(ChunkStatus requestedStatus, ChunkMap chunkLoadingManager) {
        throw new UnsupportedOperationException();
    }

    CompletableFuture<ChunkResult<ChunkAccess>> applyStep(ChunkStep step, GeneratingChunkMap chunkLoadingManager, StaticCache2D<GenerationChunkHolder> chunks) {
        throw new UnsupportedOperationException();
    }

    protected void updateHighestAllowedStatus(ChunkMap chunkLoadingManager) {
        throw new UnsupportedOperationException();
    }

    public void replaceProtoChunk(ImposterProtoChunk chunk) {
        throw new UnsupportedOperationException();
    }

    void removeTask(ChunkGenerationTask loader) {
        throw new UnsupportedOperationException();
    }

    private void rescheduleChunkTask(ChunkMap chunkLoadingManager, @Nullable ChunkStatus requestedStatus) {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getOrCreateFuture(ChunkStatus status) {
        throw new UnsupportedOperationException();
    }

    private void failAndClearPendingFuturesBetween(@Nullable ChunkStatus from, ChunkStatus to) {
        throw new UnsupportedOperationException();
    }

    private void failAndClearPendingFuture(int statusIndex, CompletableFuture<ChunkResult<ChunkAccess>> previousFuture) {
        throw new UnsupportedOperationException();
    }

    private void completeFuture(ChunkStatus status, ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    private ChunkStatus findHighestStatusWithPendingFuture(@Nullable ChunkStatus checkUpperBound) {
        throw new UnsupportedOperationException();
    }

    private boolean acquireStatusBump(ChunkStatus nextStatus) {
        throw new UnsupportedOperationException();
    }

    private boolean isStatusDisallowed(ChunkStatus status) {
        throw new UnsupportedOperationException();
    }

    public void increaseGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    public void decreaseGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    public int getGenerationRefCount() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ChunkAccess getChunkIfPresentUnchecked(ChunkStatus requestedStatus) {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkIfPresentUnchecked(requestedStatus);
    }

    @Nullable
    public ChunkAccess getChunkIfPresent(ChunkStatus requestedStatus) {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkIfPresent(requestedStatus);
    }

    @Nullable
    public ChunkAccess getLatestChunk() {
        NewChunkHolder.ChunkCompletion lastCompletion = ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.chunk();
    }

    @Nullable
    public ChunkStatus getPersistedStatus() {
        ChunkAccess chunk = this.getLatestChunk();
        return chunk == null ? null : chunk.getPersistedStatus();
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public FullChunkStatus getFullStatus() {
        return ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getChunkStatus();
    }

    public abstract int getTicketLevel();

    public abstract int getQueueLevel();

    @VisibleForDebug
    public List<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    @VisibleForDebug
    public ChunkStatus getLatestStatus() {
        NewChunkHolder.ChunkCompletion lastCompletion = ((ChunkSystemChunkHolder)((Object)this)).moonrise$getRealChunkHolder().getLastChunkCompletion();
        return lastCompletion == null ? null : lastCompletion.genStatus();
    }
}

