/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.moonrise.patches.chunk_system.io.RegionFileIOThread;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemDistanceManager;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TickingTracker;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.TrackingRange;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider,
GeneratingChunkMap {
    private static final ChunkResult<List<ChunkAccess>> UNLOADED_CHUNK_LIST_RESULT = ChunkResult.error("Unloaded chunks found in range");
    private static final CompletableFuture<ChunkResult<List<ChunkAccess>>> UNLOADED_CHUNK_LIST_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK_LIST_RESULT);
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    private final BlockableEventLoop<Runnable> mainThreadExecutor;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    private final Supplier<DimensionDataStorage> overworldDataStorage;
    private final PoiManager poiManager;
    public final LongSet toDrop;
    private boolean modified;
    public final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final ChunkDistanceManager distanceManager;
    public final AtomicInteger tickingGenerated;
    private final String storageName;
    private final PlayerMap playerMap;
    public final Int2ObjectMap<TrackedEntity> entityMap;
    private final Long2ByteMap chunkTypeCache;
    private final Long2LongMap chunkSaveCooldowns;
    public int serverViewDistance;
    public final WorldGenContext worldGenContext;
    public final CallbackExecutor callbackExecutor = new CallbackExecutor();
    private final PooledLinkedHashSets<ServerPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    public final NearbyPlayers nearbyPlayers;

    void addPlayerToDistanceMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.addPlayer(player);
    }

    void removePlayerFromDistanceMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.removePlayer(player);
    }

    void updateMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.tickPlayer(player);
    }

    public final ChunkHolder getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    public ChunkMap(ServerLevel world, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, BlockableEventLoop<Runnable> mainThreadExecutor, LightChunkGetter chunkProvider, ChunkGenerator chunkGenerator, ChunkProgressListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<DimensionDataStorage> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(new RegionStorageInfo(session.getLevelId(), world.dimension(), "chunk"), session.getDimensionPath(world.dimension()).resolve("region"), dataFixer, dsync);
        this.toDrop = new LongOpenHashSet();
        this.tickingGenerated = new AtomicInteger();
        this.playerMap = new PlayerMap();
        this.entityMap = new Int2ObjectOpenHashMap();
        this.chunkTypeCache = new Long2ByteOpenHashMap();
        this.chunkSaveCooldowns = new Long2LongOpenHashMap();
        Path path = session.getDimensionPath(world.dimension());
        this.storageName = path.getFileName().toString();
        this.level = world;
        RegistryAccess iregistrycustom = world.registryAccess();
        long j = world.getSeed();
        ChunkGenerator randomGenerator = chunkGenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator chunkgeneratorabstract = (NoiseBasedChunkGenerator)randomGenerator;
            this.randomState = RandomState.create(chunkgeneratorabstract.generatorSettings().value(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        }
        this.chunkGeneratorState = chunkGenerator.createState(iregistrycustom.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, j, world.spigotConfig);
        this.mainThreadExecutor = mainThreadExecutor;
        ProcessorMailbox<Runnable> threadedmailbox = ProcessorMailbox.create(executor, "worldgen");
        Objects.requireNonNull(mainThreadExecutor);
        ProcessorHandle<Runnable> mailbox = ProcessorHandle.of("main", mainThreadExecutor::tell);
        this.progressListener = worldGenerationProgressListener;
        this.chunkStatusListener = chunkStatusChangeListener;
        ProcessorMailbox<Runnable> threadedmailbox1 = ProcessorMailbox.create(executor, "light");
        this.lightEngine = new ThreadedLevelLightEngine(chunkProvider, this, this.level.dimensionType().hasSkyLight(), threadedmailbox1, null);
        this.distanceManager = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.overworldDataStorage = persistentStateManagerFactory;
        this.poiManager = new PoiManager(new RegionStorageInfo(session.getLevelId(), world.dimension(), "poi"), path.resolve("poi"), dataFixer, dsync, iregistrycustom, world.getServer(), world);
        this.setServerViewDistance(viewDistance);
        this.worldGenContext = new WorldGenContext(world, chunkGenerator, structureTemplateManager, this.lightEngine, null);
        this.nearbyPlayers = new NearbyPlayers(this.level);
    }

    public final NearbyPlayers getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.getType().getCategory().ordinal();
        ReferenceList<ServerPlayer> inRange = this.getNearbyPlayers().getPlayers(entity.chunkPosition(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = index;
            ((ServerPlayer)backingSet[i]).mobCounts[n] = ((ServerPlayer)backingSet[i]).mobCounts[n] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, MobCategory mobCategory) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<ServerPlayer> inRange = this.getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = idx;
            ((ServerPlayer)backingSet[i]).mobBackoffCounts[n] = ((ServerPlayer)backingSet[i]).mobBackoffCounts[n] + 1;
        }
    }

    public int getMobCountNear(ServerPlayer player, MobCategory mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    protected ChunkGenerator generator() {
        return this.worldGenContext.generator();
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    private static double euclideanDistanceSquared(ChunkPos pos, net.minecraft.world.entity.Entity entity) {
        double d0 = SectionPos.sectionToBlockCoord(pos.x, 8);
        double d1 = SectionPos.sectionToBlockCoord(pos.z, 8);
        double d2 = d0 - entity.getX();
        double d3 = d1 - entity.getZ();
        return d2 * d2 + d3 * d3;
    }

    boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return this.level.moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ);
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer player, int chunkX, int chunkZ) {
        return this.level.moonrise$getPlayerChunkLoader().isChunkSent(player, chunkX, chunkZ, true);
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected ChunkHolder getUpdatingChunkIfPresent(long pos) {
        NewChunkHolder holder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public ChunkHolder getVisibleChunkIfPresent(long pos) {
        NewChunkHolder holder = this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier getChunkQueueLevel(long pos) {
        throw new UnsupportedOperationException();
    }

    public String getChunkDebugData(ChunkPos chunkPos) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (playerchunk == null) {
            return "null";
        }
        String s = playerchunk.getTicketLevel() + "\n";
        ChunkStatus chunkstatus = playerchunk.getLatestStatus();
        ChunkAccess ichunkaccess = playerchunk.getLatestChunk();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.getIndex() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s = s + "Ch: \u00a7" + ichunkaccess.getPersistedStatus().getIndex() + String.valueOf(ichunkaccess.getPersistedStatus()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.getFullStatus();
        s = s + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException exception, String details) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<ChunkHolder> consumer = playerchunk -> playerchunk.getAllFutures().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.getPos()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        ChunkSystem.getUpdatingChunkHolders(this.level).forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        ChunkSystem.getVisibleChunkHolders(this.level).forEach(consumer);
        CrashReport crashreport = CrashReport.forThrowable(exception, "Chunk loading");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk loading");
        crashreportsystemdetails.setDetail("Details", details);
        crashreportsystemdetails.setDetail("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long pos, int level, @Nullable ChunkHolder holder, int k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void saveAllChunks(boolean flush) {
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void tick(BooleanSupplier shouldKeepTicking) {
        ProfilerFiller gameprofilerfiller = this.level.getProfiler();
        gameprofilerfiller.push("poi");
        this.poiManager.tick(shouldKeepTicking);
        gameprofilerfiller.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(shouldKeepTicking);
        }
        gameprofilerfiller.pop();
    }

    public boolean hasWork() {
        throw new UnsupportedOperationException();
    }

    private void processUnloads(BooleanSupplier shouldKeepTicking) {
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.processUnloads();
        this.level.moonrise$getChunkTaskScheduler().chunkHolderManager.autoSave();
    }

    private void scheduleUnload(long pos, ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    protected boolean promoteChunkMap() {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    private static boolean isChunkDataValid(CompoundTag nbt) {
        return nbt.contains("Status", 8);
    }

    private ChunkAccess handleChunkLoadFailure(Throwable throwable, ChunkPos chunkPos) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            this.level.getServer().reportChunkLoadFailure(throwable3, this.storageInfo(), chunkPos);
            return this.createEmptyChunk(chunkPos);
        }
        CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception loading chunk");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk being loaded");
        crashreportsystemdetails.setDetail("pos", chunkPos);
        this.markPositionReplaceable(chunkPos);
        throw new ReportedException(crashreport);
    }

    private ChunkAccess createEmptyChunk(ChunkPos chunkPos) {
        this.markPositionReplaceable(chunkPos);
        return new ProtoChunk(chunkPos, UpgradeData.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos pos) {
        this.chunkTypeCache.put(pos.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos pos, ChunkType type) {
        return this.chunkTypeCache.put(pos.toLong(), (byte)(type == ChunkType.PROTOCHUNK ? -1 : 1));
    }

    @Override
    public GenerationChunkHolder acquireGeneration(long pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseGeneration(GenerationChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<ChunkAccess> applyStep(GenerationChunkHolder chunkHolder, ChunkStep step, StaticCache2D<GenerationChunkHolder> chunks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ChunkGenerationTask scheduleGenerationTask(ChunkStatus requestedStatus, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    private void runGenerationTask(ChunkGenerationTask chunkLoader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void runGenerationTasks() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    private void onChunkReadyToSend(LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public boolean save(ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean isExistingChunkFull(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    public void setServerViewDistance(int watchDistance) {
        int clamped = Mth.clamp(watchDistance, 2, 32);
        if (clamped == this.serverViewDistance) {
            return;
        }
        this.serverViewDistance = clamped;
        this.level.moonrise$getPlayerChunkLoader().setLoadDistance(this.serverViewDistance + 1);
    }

    public int getPlayerViewDistance(ServerPlayer player) {
        return ca.spottedleaf.moonrise.patches.chunk_system.ChunkSystem.getSendViewDistance(player);
    }

    private void markChunkPendingToSend(ServerPlayer player, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void dropChunk(ServerPlayer player, ChunkPos pos) {
    }

    @Override
    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos pos) {
        if (!RegionFileIOThread.isRegionFileThread()) {
            try {
                return CompletableFuture.completedFuture(Optional.ofNullable(RegionFileIOThread.loadData(this.level, pos.x, pos.z, RegionFileIOThread.RegionFileType.CHUNK_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread())));
            }
            catch (Throwable thr) {
                return CompletableFuture.failedFuture(thr);
            }
        }
        return super.read(pos);
    }

    @Override
    public CompletableFuture<Void> write(ChunkPos pos, CompoundTag tag) {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.level, pos.x, pos.z, tag, RegionFileIOThread.RegionFileType.CHUNK_DATA);
            return null;
        }
        super.write(pos, tag);
        return null;
    }

    @Override
    public void flushWorker() {
        RegionFileIOThread.flush();
    }

    @Nullable
    public LevelChunk getChunkToSend(long pos) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos);
        return playerchunk == null ? null : playerchunk.getChunkToSend();
    }

    public int size() {
        return ChunkSystem.getVisibleChunkHolderCount(this.level);
    }

    public DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable(ChunkSystem.getVisibleChunkHolders(this.level));
    }

    void dumpChunks(Writer writer) throws IOException {
        CsvOutput csvwriter = CsvOutput.builder().addColumn("x").addColumn("z").addColumn("level").addColumn("in_memory").addColumn("status").addColumn("full_status").addColumn("accessible_ready").addColumn("ticking_ready").addColumn("entity_ticking_ready").addColumn("ticket").addColumn("spawning").addColumn("block_entity_count").addColumn("ticking_ticket").addColumn("ticking_level").addColumn("block_ticks").addColumn("fluid_ticks").build(writer);
        TickingTracker tickingtracker = this.distanceManager.tickingTracker();
        for (ChunkHolder playerchunk : ChunkSystem.getVisibleChunkHolders(this.level)) {
            long i = playerchunk.pos.toLong();
            ChunkPos chunkcoordintpair = new ChunkPos(i);
            Optional<ChunkAccess> optional = Optional.ofNullable(playerchunk.getLatestChunk());
            Optional<Object> optional1 = optional.flatMap(ichunkaccess -> ichunkaccess instanceof LevelChunk ? Optional.of((LevelChunk)ichunkaccess) : Optional.empty());
            csvwriter.writeRow(chunkcoordintpair.x, chunkcoordintpair.z, playerchunk.getTicketLevel(), optional.isPresent(), optional.map(ChunkAccess::getPersistedStatus).orElse(null), optional1.map(LevelChunk::getFullStatus).orElse(null), ChunkMap.printFuture(playerchunk.getFullChunkFuture()), ChunkMap.printFuture(playerchunk.getTickingChunkFuture()), ChunkMap.printFuture(playerchunk.getEntityTickingChunkFuture()), this.distanceManager.getTicketDebugString(i), this.anyPlayerCloseEnoughForSpawning(chunkcoordintpair), optional1.map(chunk -> chunk.getBlockEntities().size()).orElse(0), tickingtracker.getTicketDebugString(i), tickingtracker.getLevel(i), optional1.map(chunk -> chunk.getBlockTicks().count()).orElse(0), optional1.map(chunk -> chunk.getFluidTicks().count()).orElse(0));
        }
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> future) {
        try {
            ChunkResult chunkresult = future.getNow(null);
            return chunkresult != null ? (chunkresult.isSuccess() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos chunkPos) {
        return this.read(chunkPos).thenApplyAsync(optional -> optional.map(nbttagcompound -> this.upgradeChunkTag((CompoundTag)nbttagcompound, chunkPos)), (Executor)Util.backgroundExecutor());
    }

    public CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, ChunkPos chunkcoordintpair) {
        return this.upgradeChunkTag(this.level.getTypeKey(), this.overworldDataStorage, nbttagcompound, this.generator().getTypeNameForDataFixer(), chunkcoordintpair, this.level);
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkcoordintpair, boolean reducedRange) {
        ServerPlayer entityplayer;
        int chunkRange = this.level.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.level.spigotConfig.viewDistance ? (int)this.level.spigotConfig.viewDistance : chunkRange;
        int finalChunkRange = chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = 16384.0;
        if (!this.distanceManager.hasPlayersNearby(chunkcoordintpair.toLong())) {
            return false;
        }
        Iterator<ServerPlayer> iterator = this.playerMap.getAllPlayers().iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            entityplayer = iterator.next();
            blockRange = 16384.0;
            if (!reducedRange) continue;
            PlayerNaturallySpawnCreaturesEvent event = entityplayer.playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled()) {
                return false;
            }
            blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange));
        return true;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos pos) {
        long i = pos.toLong();
        if (!this.distanceManager.hasPlayersNearby(i)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(ServerPlayer entityplayer, ChunkPos chunkcoordintpair, double range) {
        if (entityplayer.isSpectator()) {
            return false;
        }
        double d0 = ChunkMap.euclideanDistanceSquared(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean skipPlayer(ServerPlayer player) {
        return player.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS);
    }

    void updatePlayerStatus(ServerPlayer player, boolean added) {
        boolean flag1 = this.skipPlayer(player);
        boolean flag2 = this.playerMap.ignoredOrUnknown(player);
        if (added) {
            this.playerMap.addPlayer(player, flag1);
            this.updatePlayerPos(player);
            if (!flag1) {
                this.distanceManager.addPlayer(SectionPos.of(player), player);
            }
            player.setChunkTrackingView(ChunkTrackingView.EMPTY);
            ca.spottedleaf.moonrise.patches.chunk_system.ChunkSystem.addPlayerToDistanceMaps(this.level, player);
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPos sectionposition = player.getLastSectionPos();
            this.playerMap.removePlayer(player);
            if (!flag2) {
                this.distanceManager.removePlayer(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
            ca.spottedleaf.moonrise.patches.chunk_system.ChunkSystem.removePlayerFromDistanceMaps(this.level, player);
        }
    }

    private void updatePlayerPos(ServerPlayer player) {
        SectionPos sectionposition = SectionPos.of(player);
        player.setLastSectionPos(sectionposition);
    }

    public void move(ServerPlayer player) {
        boolean flag2;
        for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
            if (playerchunkmap_entitytracker.entity == player) {
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                continue;
            }
            playerchunkmap_entitytracker.updatePlayer(player);
        }
        SectionPos sectionposition = player.getLastSectionPos();
        SectionPos sectionposition1 = SectionPos.of(player);
        boolean flag = this.playerMap.ignored(player);
        boolean flag1 = this.skipPlayer(player);
        boolean bl = flag2 = sectionposition.asLong() != sectionposition1.asLong();
        if (flag2 || flag != flag1) {
            this.updatePlayerPos(player);
            if (!flag) {
                this.distanceManager.removePlayer(sectionposition, player);
            }
            if (!flag1) {
                this.distanceManager.addPlayer(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.playerMap.ignorePlayer(player);
            }
            if (flag && !flag1) {
                this.playerMap.unIgnorePlayer(player);
            }
        }
        this.updateMaps(player);
        ca.spottedleaf.moonrise.patches.chunk_system.ChunkSystem.updateMaps(this.level, player);
    }

    private void updateChunkTracking(ServerPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (holder == null) {
            return new ArrayList<ServerPlayer>();
        }
        return holder.moonrise$getPlayers(onlyOnWatchDistanceEdge);
    }

    public void addEntity(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.level() != this.level || this.entityMap.containsKey(entity.getId())) {
            LOGGER.error("Illegal ChunkMap::addEntity for world " + this.level.getWorld().getName() + ": " + String.valueOf(entity) + (this.entityMap.containsKey(entity.getId()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof ServerPlayer && ((ServerPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EnderDragonPart)) {
            EntityType<?> entitytypes = entity.getType();
            int i = entitytypes.clientTrackingRange() * 16;
            if ((i = TrackingRange.getEntityTrackingRange(entity, i)) != 0) {
                TrackedEntity playerchunkmap_entitytracker;
                int j = entitytypes.updateInterval();
                if (this.entityMap.containsKey(entity.getId())) {
                    throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new TrackedEntity(entity, i, j, entitytypes.trackDeltas());
                this.entityMap.put(entity.getId(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(this.level.players());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity;
                    this.updatePlayerStatus(entityplayer, true);
                    for (TrackedEntity playerchunkmap_entitytracker1 : this.entityMap.values()) {
                        if (playerchunkmap_entitytracker1.entity == entityplayer) continue;
                        playerchunkmap_entitytracker1.updatePlayer(entityplayer);
                    }
                }
            }
        }
    }

    protected void removeEntity(net.minecraft.world.entity.Entity entity) {
        TrackedEntity playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            this.updatePlayerStatus(entityplayer, false);
            for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
                playerchunkmap_entitytracker.removePlayer(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (TrackedEntity)this.entityMap.remove(entity.getId())) != null) {
            playerchunkmap_entitytracker1.broadcastRemoved();
        }
        entity.tracker = null;
    }

    protected void tick() {
        TrackedEntity playerchunkmap_entitytracker;
        ArrayList list = Lists.newArrayList();
        List<ServerPlayer> list1 = this.level.players();
        ObjectIterator objectiterator = this.entityMap.values().iterator();
        this.level.timings.tracker1.startTiming();
        while (objectiterator.hasNext()) {
            boolean flag;
            playerchunkmap_entitytracker = (TrackedEntity)objectiterator.next();
            SectionPos sectionposition = playerchunkmap_entitytracker.lastSectionPos;
            SectionPos sectionposition1 = SectionPos.of(playerchunkmap_entitytracker.entity);
            boolean bl = flag = !Objects.equals(sectionposition, sectionposition1);
            if (flag) {
                playerchunkmap_entitytracker.updatePlayers(list1);
                net.minecraft.world.entity.Entity entity = playerchunkmap_entitytracker.entity;
                if (entity instanceof ServerPlayer) {
                    list.add((ServerPlayer)entity);
                }
                playerchunkmap_entitytracker.lastSectionPos = sectionposition1;
            }
            if (!flag && !this.distanceManager.inEntityTickingRange(sectionposition1.chunk().toLong())) continue;
            playerchunkmap_entitytracker.serverEntity.sendChanges();
        }
        this.level.timings.tracker1.stopTiming();
        if (!list.isEmpty()) {
            objectiterator = this.entityMap.values().iterator();
            this.level.timings.tracker2.startTiming();
            while (objectiterator.hasNext()) {
                playerchunkmap_entitytracker = (TrackedEntity)objectiterator.next();
                playerchunkmap_entitytracker.updatePlayers(list);
            }
            this.level.timings.tracker2.stopTiming();
        }
    }

    public void broadcast(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcast(packet);
        }
    }

    protected void broadcastAndSend(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcastAndSend(packet);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> chunks) {
        HashMap<ServerPlayer, List> map = new HashMap<ServerPlayer, List>();
        for (ChunkAccess ichunkaccess : chunks) {
            LevelChunk chunk1;
            ChunkPos chunkcoordintpair = ichunkaccess.getPos();
            LevelChunk chunk = ichunkaccess instanceof LevelChunk ? (chunk1 = (LevelChunk)ichunkaccess) : this.level.getChunk(chunkcoordintpair.x, chunkcoordintpair.z);
            for (ServerPlayer entityplayer : this.getPlayers(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.connection.send(ClientboundChunksBiomesPacket.forChunks(list1)));
    }

    protected PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos chunkPos, FullChunkStatus levelType) {
        this.chunkStatusListener.onChunkStatusChange(chunkPos, levelType);
    }

    public void waitForLightBeforeSending(ChunkPos centerPos, int radius) {
    }

    public static final class CallbackExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> queue = new ArrayDeque<Runnable>();

        @Override
        public void execute(Runnable runnable) {
            this.queue.add(runnable);
        }

        @Override
        public void run() {
            Runnable task;
            while ((task = this.queue.poll()) != null) {
                task.run();
            }
        }
    }

    public class ChunkDistanceManager
    extends DistanceManager
    implements ChunkSystemDistanceManager {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, ChunkMap.this);
        }

        @Override
        public final ChunkMap moonrise$getChunkMap() {
            return ChunkMap.this;
        }

        @Override
        protected boolean isChunkToRemove(long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long pos) {
            return ChunkMap.this.getUpdatingChunkIfPresent(pos);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long pos, int level, @Nullable ChunkHolder holder, int k) {
            return ChunkMap.this.updateChunkScheduling(pos, level, holder, k);
        }
    }

    public class TrackedEntity {
        public final ServerEntity serverEntity;
        final net.minecraft.world.entity.Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = new ReferenceOpenHashSet();

        public TrackedEntity(net.minecraft.world.entity.Entity entity, int i, int j, boolean flag) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, entity, j, flag, this::broadcast, this.seenBy);
            this.entity = entity;
            this.range = i;
            this.lastSectionPos = SectionPos.of(entity);
        }

        public boolean equals(Object object) {
            return object instanceof TrackedEntity ? ((TrackedEntity)object).entity.getId() == this.entity.getId() : false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                serverplayerconnection.send(packet);
            }
        }

        public void broadcastAndSend(Packet<?> packet) {
            this.broadcast(packet);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send(packet);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                this.serverEntity.removePairing(serverplayerconnection.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.seenBy.remove(player.connection)) {
                this.serverEntity.removePairing(player);
            }
        }

        public void updatePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.entity) {
                double rangeY;
                boolean flag;
                double vec3d_dx = player.getX() - this.entity.getX();
                double vec3d_dz = player.getZ() - this.entity.getZ();
                int i = ChunkMap.this.getPlayerViewDistance(player);
                double d1 = vec3d_dx * vec3d_dx + vec3d_dz * vec3d_dz;
                double d0 = Math.min(this.getEffectiveRange(), i * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.entity.broadcastToPlayer(player) && ChunkMap.this.isChunkTracked(player, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
                if (flag && ChunkMap.this.level.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)ChunkMap.this.level.paperConfig().entities.trackingRangeY.get(this.entity, -1)) != -1.0) {
                    double vec3d_dy = player.getY() - this.entity.getY();
                    boolean bl2 = flag = vec3d_dy * vec3d_dy <= rangeY * rangeY;
                }
                if (flag && !player.getBukkitEntity().canSee(this.entity.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.seenBy.add(player.connection) && (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.entity.getBukkitEntity()).callEvent())) {
                        this.serverEntity.addPairing(player);
                    }
                } else if (this.seenBy.remove(player.connection)) {
                    this.serverEntity.removePairing(player);
                }
            }
        }

        private int scaledRange(int initialDistance) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance(initialDistance);
        }

        private int getEffectiveRange() {
            int i = this.range;
            for (net.minecraft.world.entity.Entity entity : this.entity.getIndirectPassengers()) {
                int j = entity.getType().clientTrackingRange() * 16;
                if ((j = TrackingRange.getEntityTrackingRange(entity, j)) <= i) continue;
                i = j;
            }
            return this.scaledRange(i);
        }

        public void updatePlayers(List<ServerPlayer> players) {
            for (ServerPlayer entityplayer : players) {
                this.updatePlayer(entityplayer);
            }
        }
    }
}

