/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType ERROR_MERGE_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType ERROR_GET_NOT_NUMBER = new DynamicCommandExceptionType(path -> Component.translatableEscape("commands.data.get.invalid", path));
    private static final DynamicCommandExceptionType ERROR_GET_NON_EXISTENT = new DynamicCommandExceptionType(path -> Component.translatableEscape("commands.data.get.unknown", path));
    private static final SimpleCommandExceptionType ERROR_MULTIPLE_TAGS = new SimpleCommandExceptionType((Message)Component.translatable("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_OBJECT = new DynamicCommandExceptionType(nbt -> Component.translatableEscape("commands.data.modify.expected_object", nbt));
    private static final DynamicCommandExceptionType ERROR_EXPECTED_VALUE = new DynamicCommandExceptionType(nbt -> Component.translatableEscape("commands.data.modify.expected_value", nbt));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_SUBSTRING = new Dynamic2CommandExceptionType((startIndex, endIndex) -> Component.translatableEscape("commands.data.modify.invalid_substring", startIndex, endIndex));
    public static final List<Function<String, DataProvider>> ALL_PROVIDERS = ImmutableList.of(EntityDataAccessor.PROVIDER, BlockDataAccessor.PROVIDER, StorageDataAccessor.PROVIDER);
    public static final List<DataProvider> TARGET_PROVIDERS = (List)ALL_PROVIDERS.stream().map(factory -> (DataProvider)factory.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> SOURCE_PROVIDERS = (List)ALL_PROVIDERS.stream().map(factory -> (DataProvider)factory.apply("source")).collect(ImmutableList.toImmutableList());

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal("data").requires(source -> source.hasPermission(2));
        for (DataProvider dataProvider : TARGET_PROVIDERS) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("merge"), builder -> builder.then(Commands.argument("nbt", CompoundTagArgument.compoundTag()).executes(context -> DataCommands.mergeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), CompoundTagArgument.getCompoundTag(context, "nbt"))))))).then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("get"), builder -> ((ArgumentBuilder)builder.executes(context -> DataCommands.getData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context)))).then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).executes(context -> DataCommands.getData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path")))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(context -> DataCommands.getNumeric((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))))).then(dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("remove"), builder -> builder.then(Commands.argument("path", NbtPathArgument.nbtPath()).executes(context -> DataCommands.removeData((CommandSourceStack)context.getSource(), dataProvider.access((CommandContext<CommandSourceStack>)context), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)context, "path"))))))).then(DataCommands.decorateModification((builder, modifier) -> ((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)((ArgumentBuilder)builder.then(Commands.literal("insert").then(Commands.argument("index", IntegerArgumentType.integer()).then(modifier.create((context, sourceNbt, path, elements) -> path.insert(IntegerArgumentType.getInteger((CommandContext)context, (String)"index"), sourceNbt, elements)))))).then(Commands.literal("prepend").then(modifier.create((context, sourceNbt, path, elements) -> path.insert(0, sourceNbt, elements))))).then(Commands.literal("append").then(modifier.create((context, sourceNbt, path, elements) -> path.insert(-1, sourceNbt, elements))))).then(Commands.literal("set").then(modifier.create((context, sourceNbt, path, elements) -> path.set(sourceNbt, (Tag)Iterables.getLast((Iterable)elements)))))).then(Commands.literal("merge").then(modifier.create((context, element, path, elements) -> {
                CompoundTag compoundTag = new CompoundTag();
                for (Tag tag : elements) {
                    if (NbtPathArgument.NbtPath.isTooDeep(tag, 0)) {
                        throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
                    }
                    if (tag instanceof CompoundTag) {
                        CompoundTag compoundTag2 = (CompoundTag)tag;
                        compoundTag.merge(compoundTag2);
                        continue;
                    }
                    throw ERROR_EXPECTED_OBJECT.create((Object)tag);
                }
                List<Tag> collection = path.getOrCreate(element, CompoundTag::new);
                int i = 0;
                for (Tag tag2 : collection) {
                    void compoundTag4;
                    if (!(tag2 instanceof CompoundTag)) {
                        throw ERROR_EXPECTED_OBJECT.create((Object)tag2);
                    }
                    CompoundTag compoundTag3 = (CompoundTag)tag2;
                    CompoundTag compoundTag5 = compoundTag4.copy();
                    compoundTag4.merge(compoundTag);
                    i += compoundTag5.equals(compoundTag4) ? 0 : 1;
                }
                return i;
            })))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalArgumentBuilder);
    }

    private static String getAsText(Tag nbt) throws CommandSyntaxException {
        if (nbt.getType().isValue()) {
            return nbt.getAsString();
        }
        throw ERROR_EXPECTED_VALUE.create((Object)nbt);
    }

    private static List<Tag> stringifyTagList(List<Tag> list, StringProcessor processor) throws CommandSyntaxException {
        ArrayList<Tag> list2 = new ArrayList<Tag>(list.size());
        for (Tag tag : list) {
            String string = DataCommands.getAsText(tag);
            list2.add(StringTag.valueOf(processor.process(string)));
        }
        return list2;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> decorateModification(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> subArgumentAdder) {
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder = Commands.literal("modify");
        for (DataProvider dataProvider : TARGET_PROVIDERS) {
            dataProvider.wrap((ArgumentBuilder<CommandSourceStack, ?>)literalArgumentBuilder, builder -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> argumentBuilder = Commands.argument("targetPath", NbtPathArgument.nbtPath());
                for (DataProvider dataProvider2 : SOURCE_PROVIDERS) {
                    subArgumentAdder.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder, operation -> dataProvider2.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("from"), builderx -> ((ArgumentBuilder)builderx.executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)context, dataProvider2)))).then(Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider2))))));
                    subArgumentAdder.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder, operation -> dataProvider2.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("string"), builderx -> ((ArgumentBuilder)builderx.executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.stringifyTagList(DataCommands.getSingletonSource((CommandContext<CommandSourceStack>)context, dataProvider2), value -> value)))).then(((RequiredArgumentBuilder)Commands.argument("sourcePath", NbtPathArgument.nbtPath()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider2), value -> value)))).then(((RequiredArgumentBuilder)Commands.argument("start", IntegerArgumentType.integer()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider2), value -> DataCommands.substring(value, IntegerArgumentType.getInteger((CommandContext)context, (String)"start")))))).then(Commands.argument("end", IntegerArgumentType.integer()).executes(context -> DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, operation, DataCommands.stringifyTagList(DataCommands.resolveSourcePath((CommandContext<CommandSourceStack>)context, dataProvider2), value -> DataCommands.substring(value, IntegerArgumentType.getInteger((CommandContext)context, (String)"start"), IntegerArgumentType.getInteger((CommandContext)context, (String)"end"))))))))));
                }
                subArgumentAdder.accept((ArgumentBuilder<CommandSourceStack, ?>)argumentBuilder, modifier -> Commands.literal("value").then(Commands.argument("value", NbtTagArgument.nbtTag()).executes(context -> {
                    List<Tag> list = Collections.singletonList(NbtTagArgument.getNbtTag(context, "value"));
                    return DataCommands.manipulateData((CommandContext<CommandSourceStack>)context, dataProvider, modifier, list);
                })));
                return builder.then(argumentBuilder);
            });
        }
        return literalArgumentBuilder;
    }

    private static String validatedSubstring(String string, int startIndex, int endIndex) throws CommandSyntaxException {
        if (startIndex < 0 || endIndex > string.length() || startIndex > endIndex) {
            throw ERROR_INVALID_SUBSTRING.create((Object)startIndex, (Object)endIndex);
        }
        return string.substring(startIndex, endIndex);
    }

    private static String substring(String string, int startIndex, int endIndex) throws CommandSyntaxException {
        int i = string.length();
        int j = DataCommands.getOffset(startIndex, i);
        int k = DataCommands.getOffset(endIndex, i);
        return DataCommands.validatedSubstring(string, j, k);
    }

    private static String substring(String string, int startIndex) throws CommandSyntaxException {
        int i = string.length();
        return DataCommands.validatedSubstring(string, DataCommands.getOffset(startIndex, i), i);
    }

    private static int getOffset(int index, int length) {
        return index >= 0 ? index : length + index;
    }

    private static List<Tag> getSingletonSource(CommandContext<CommandSourceStack> context, DataProvider objectType) throws CommandSyntaxException {
        DataAccessor dataAccessor = objectType.access(context);
        return Collections.singletonList(dataAccessor.getData());
    }

    private static List<Tag> resolveSourcePath(CommandContext<CommandSourceStack> context, DataProvider objectType) throws CommandSyntaxException {
        DataAccessor dataAccessor = objectType.access(context);
        NbtPathArgument.NbtPath nbtPath = NbtPathArgument.getPath(context, "sourcePath");
        return nbtPath.get(dataAccessor.getData());
    }

    private static int manipulateData(CommandContext<CommandSourceStack> context, DataProvider objectType, DataManipulator modifier, List<Tag> elements) throws CommandSyntaxException {
        DataAccessor dataAccessor = objectType.access(context);
        NbtPathArgument.NbtPath nbtPath = NbtPathArgument.getPath(context, "targetPath");
        CompoundTag compoundTag = dataAccessor.getData();
        int i = modifier.modify(context, compoundTag, nbtPath, elements);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        dataAccessor.setData(compoundTag);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> dataAccessor.getModifiedSuccess(), true);
        return i;
    }

    private static int removeData(CommandSourceStack source, DataAccessor object, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        CompoundTag compoundTag = object.getData();
        int i = path.remove(compoundTag);
        if (i == 0) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        object.setData(compoundTag);
        source.sendSuccess(() -> object.getModifiedSuccess(), true);
        return i;
    }

    public static Tag getSingleTag(NbtPathArgument.NbtPath path, DataAccessor object) throws CommandSyntaxException {
        List<Tag> collection = path.get(object.getData());
        Iterator iterator = collection.iterator();
        Tag tag = (Tag)iterator.next();
        if (iterator.hasNext()) {
            throw ERROR_MULTIPLE_TAGS.create();
        }
        return tag;
    }

    /*
     * WARNING - void declaration
     */
    private static int getData(CommandSourceStack source, DataAccessor object, NbtPathArgument.NbtPath path) throws CommandSyntaxException {
        void m;
        Tag tag = DataCommands.getSingleTag(path, object);
        if (tag instanceof NumericTag) {
            int i = Mth.floor(((NumericTag)tag).getAsDouble());
        } else if (tag instanceof CollectionTag) {
            int j = ((CollectionTag)tag).size();
        } else if (tag instanceof CompoundTag) {
            int k = ((CompoundTag)tag).size();
        } else if (tag instanceof StringTag) {
            int l = tag.getAsString().length();
        } else {
            throw ERROR_GET_NON_EXISTENT.create((Object)path.toString());
        }
        source.sendSuccess(() -> object.getPrintSuccess(tag), false);
        return (int)m;
    }

    private static int getNumeric(CommandSourceStack source, DataAccessor object, NbtPathArgument.NbtPath path, double scale) throws CommandSyntaxException {
        Tag tag = DataCommands.getSingleTag(path, object);
        if (!(tag instanceof NumericTag)) {
            throw ERROR_GET_NOT_NUMBER.create((Object)path.toString());
        }
        int i = Mth.floor(((NumericTag)tag).getAsDouble() * scale);
        source.sendSuccess(() -> object.getPrintSuccess(path, scale, i), false);
        return i;
    }

    private static int getData(CommandSourceStack source, DataAccessor object) throws CommandSyntaxException {
        CompoundTag compoundTag = object.getData();
        source.sendSuccess(() -> object.getPrintSuccess(compoundTag), false);
        return 1;
    }

    private static int mergeData(CommandSourceStack source, DataAccessor object, CompoundTag nbt) throws CommandSyntaxException {
        CompoundTag compoundTag = object.getData();
        if (NbtPathArgument.NbtPath.isTooDeep(nbt, 0)) {
            throw NbtPathArgument.ERROR_DATA_TOO_DEEP.create();
        }
        CompoundTag compoundTag2 = compoundTag.copy().merge(nbt);
        if (compoundTag.equals(compoundTag2)) {
            throw ERROR_MERGE_UNCHANGED.create();
        }
        object.setData(compoundTag2);
        source.sendSuccess(() -> object.getModifiedSuccess(), true);
        return 1;
    }

    public static interface DataProvider {
        public DataAccessor access(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> wrap(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }

    @FunctionalInterface
    static interface StringProcessor {
        public String process(String var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulator {
        public int modify(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> create(DataManipulator var1);
    }
}

