/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomSequences;

public class RandomCommand {
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_LARGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_large"));
    private static final SimpleCommandExceptionType ERROR_RANGE_TOO_SMALL = new SimpleCommandExceptionType((Message)Component.translatable("commands.random.error.range_too_small"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("random").then(RandomCommand.drawRandomValueTree("value", false))).then(RandomCommand.drawRandomValueTree("roll", true))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("reset").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("*").executes(context -> RandomCommand.resetAllSequences((CommandSourceStack)context.getSource()))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.resetAllSequencesAndSetNewDefaults((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId")))))))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).executes(context -> RandomCommand.resetSequence((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sequence")))).then(((RequiredArgumentBuilder)Commands.argument("seed", IntegerArgumentType.integer()).executes(context -> RandomCommand.resetSequence((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), true, true))).then(((RequiredArgumentBuilder)Commands.argument("includeWorldSeed", BoolArgumentType.bool()).executes(context -> RandomCommand.resetSequence((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), true))).then(Commands.argument("includeSequenceId", BoolArgumentType.bool()).executes(context -> RandomCommand.resetSequence((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sequence"), IntegerArgumentType.getInteger((CommandContext)context, (String)"seed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeWorldSeed"), BoolArgumentType.getBool((CommandContext)context, (String)"includeSequenceId"))))))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> drawRandomValueTree(String argumentName, boolean roll) {
        return (LiteralArgumentBuilder)Commands.literal(argumentName).then(((RequiredArgumentBuilder)Commands.argument("range", RangeArgument.intRange()).executes(context -> RandomCommand.randomSample((CommandSourceStack)context.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)context, "range"), null, roll))).then(((RequiredArgumentBuilder)Commands.argument("sequence", ResourceLocationArgument.id()).suggests(RandomCommand::suggestRandomSequence).requires(source -> source.hasPermission(2))).executes(context -> RandomCommand.randomSample((CommandSourceStack)context.getSource(), RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)context, "range"), ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sequence"), roll))));
    }

    private static CompletableFuture<Suggestions> suggestRandomSequence(CommandContext<CommandSourceStack> context, SuggestionsBuilder suggestionsBuilder) {
        ArrayList list = Lists.newArrayList();
        ((CommandSourceStack)context.getSource()).getLevel().getRandomSequences().forAllSequences((id, sequence) -> list.add(id.toString()));
        return SharedSuggestionProvider.suggest(list, suggestionsBuilder);
    }

    private static int randomSample(CommandSourceStack source, MinMaxBounds.Ints range, @Nullable ResourceLocation sequenceId, boolean roll) throws CommandSyntaxException {
        RandomSource randomSource2;
        if (sequenceId != null) {
            RandomSource randomSource = source.getLevel().getRandomSequence(sequenceId);
        } else {
            randomSource2 = source.getLevel().getRandom();
        }
        int i = range.min().orElse(Integer.MIN_VALUE);
        int j = range.max().orElse(Integer.MAX_VALUE);
        long l = (long)j - (long)i;
        if (l == 0L) {
            throw ERROR_RANGE_TOO_SMALL.create();
        }
        if (l >= Integer.MAX_VALUE) {
            throw ERROR_RANGE_TOO_LARGE.create();
        }
        int k = Mth.randomBetweenInclusive(randomSource2, i, j);
        if (roll) {
            source.getServer().getPlayerList().broadcastSystemMessage(Component.translatable("commands.random.roll", source.getDisplayName(), k, i, j), false);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.random.sample.success", k), false);
        }
        return k;
    }

    private static int resetSequence(CommandSourceStack source, ResourceLocation sequenceId) throws CommandSyntaxException {
        source.getLevel().getRandomSequences().reset(sequenceId);
        source.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(sequenceId)), false);
        return 1;
    }

    private static int resetSequence(CommandSourceStack source, ResourceLocation sequenceId, int salt, boolean includeWorldSeed, boolean includeSequenceId) throws CommandSyntaxException {
        source.getLevel().getRandomSequences().reset(sequenceId, salt, includeWorldSeed, includeSequenceId);
        source.sendSuccess(() -> Component.translatable("commands.random.reset.success", Component.translationArg(sequenceId)), false);
        return 1;
    }

    private static int resetAllSequences(CommandSourceStack source) {
        int i = source.getLevel().getRandomSequences().clear();
        source.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", i), false);
        return i;
    }

    private static int resetAllSequencesAndSetNewDefaults(CommandSourceStack source, int salt, boolean includeWorldSeed, boolean includeSequenceId) {
        RandomSequences randomSequences = source.getLevel().getRandomSequences();
        randomSequences.setSeedDefaults(salt, includeWorldSeed, includeSequenceId);
        int i = randomSequences.clear();
        source.sendSuccess(() -> Component.translatable("commands.random.reset.all.success", i), false);
        return i;
    }
}

