/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.adventure.PaperAdventure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.bukkit.event.player.PlayerGameModeChangeEvent;

public class DefaultGameModeCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("defaultgamemode").requires(source -> source.hasPermission(2))).then(Commands.argument("gamemode", GameModeArgument.gameMode()).executes(commandContext -> DefaultGameModeCommands.setMode((CommandSourceStack)commandContext.getSource(), GameModeArgument.getGameMode((CommandContext<CommandSourceStack>)commandContext, "gamemode"))))));
    }

    private static int setMode(CommandSourceStack source, GameType defaultGameMode) {
        int i = 0;
        MinecraftServer minecraftServer = source.getServer();
        minecraftServer.setDefaultGameType(defaultGameMode);
        GameType gameType = minecraftServer.getForcedGameType();
        if (gameType != null) {
            for (ServerPlayer serverPlayer : minecraftServer.getPlayerList().getPlayers()) {
                PlayerGameModeChangeEvent event = serverPlayer.setGameMode(gameType, PlayerGameModeChangeEvent.Cause.DEFAULT_GAMEMODE, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.empty());
                if (event != null && event.isCancelled()) {
                    source.sendSuccess(() -> PaperAdventure.asVanilla(event.cancelMessage()), false);
                }
                ++i;
            }
        }
        source.sendSuccess(() -> Component.translatable("commands.defaultgamemode.success", defaultGameMode.getLongDisplayName()), true);
        return i;
    }
}

