/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public abstract class ServerboundMovePlayerPacket
implements Packet<ServerGamePacketListener> {
    public final double x;
    public final double y;
    public final double z;
    public final float yRot;
    public final float xRot;
    protected final boolean onGround;
    public final boolean hasPos;
    public final boolean hasRot;

    protected ServerboundMovePlayerPacket(double x, double y, double z, float yaw, float pitch, boolean onGround, boolean changePosition, boolean changeLook) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yRot = yaw;
        this.xRot = pitch;
        this.onGround = onGround;
        this.hasPos = changePosition;
        this.hasRot = changeLook;
    }

    @Override
    @Override
    public abstract PacketType<? extends ServerboundMovePlayerPacket> type();

    @Override
    @Override
    public void handle(ServerGamePacketListener listener) {
        listener.handleMovePlayer(this);
    }

    public double getX(double currentX) {
        return this.hasPos ? this.x : currentX;
    }

    public double getY(double currentY) {
        return this.hasPos ? this.y : currentY;
    }

    public double getZ(double currentZ) {
        return this.hasPos ? this.z : currentZ;
    }

    public float getYRot(float currentYaw) {
        return this.hasRot ? this.yRot : currentYaw;
    }

    public float getXRot(float currentPitch) {
        return this.hasRot ? this.xRot : currentPitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class StatusOnly
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, StatusOnly> STREAM_CODEC = Packet.codec(StatusOnly::write, StatusOnly::read);

        public StatusOnly(boolean onGround) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, onGround, false, false);
        }

        private static StatusOnly read(FriendlyByteBuf buf) {
            boolean bl = buf.readUnsignedByte() != 0;
            return new StatusOnly(bl);
        }

        private void write(FriendlyByteBuf buf) {
            buf.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        @Override
        public PacketType<StatusOnly> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class Rot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Rot> STREAM_CODEC = Packet.codec(Rot::write, Rot::read);

        public Rot(float yaw, float pitch, boolean onGround) {
            super(0.0, 0.0, 0.0, yaw, pitch, onGround, false, true);
        }

        private static Rot read(FriendlyByteBuf buf) {
            float f = buf.readFloat();
            float g = buf.readFloat();
            boolean bl = buf.readUnsignedByte() != 0;
            return new Rot(f, g, bl);
        }

        private void write(FriendlyByteBuf buf) {
            buf.writeFloat(this.yRot);
            buf.writeFloat(this.xRot);
            buf.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        @Override
        public PacketType<Rot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class Pos
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Pos> STREAM_CODEC = Packet.codec(Pos::write, Pos::read);

        public Pos(double x, double y, double z, boolean onGround) {
            super(x, y, z, 0.0f, 0.0f, onGround, true, false);
        }

        private static Pos read(FriendlyByteBuf buf) {
            double d = buf.readDouble();
            double e = buf.readDouble();
            double f = buf.readDouble();
            boolean bl = buf.readUnsignedByte() != 0;
            return new Pos(d, e, f, bl);
        }

        private void write(FriendlyByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        @Override
        public PacketType<Pos> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PosRot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, PosRot> STREAM_CODEC = Packet.codec(PosRot::write, PosRot::read);

        public PosRot(double x, double y, double z, float yaw, float pitch, boolean onGround) {
            super(x, y, z, yaw, pitch, onGround, true, true);
        }

        private static PosRot read(FriendlyByteBuf buf) {
            double d = buf.readDouble();
            double e = buf.readDouble();
            double f = buf.readDouble();
            float g = buf.readFloat();
            float h = buf.readFloat();
            boolean bl = buf.readUnsignedByte() != 0;
            return new PosRot(d, e, f, g, h, bl);
        }

        private void write(FriendlyByteBuf buf) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeFloat(this.yRot);
            buf.writeFloat(this.xRot);
            buf.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        @Override
        public PacketType<PosRot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

