/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import co.aikar.timings.MinecraftTimings;
import co.aikar.timings.Timing;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.util.thread.BlockableEventLoop;
import org.slf4j.Logger;

public class PacketUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T listener, ServerLevel world) throws RunningOnDifferentThreadException {
        PacketUtils.ensureRunningOnSameThread(packet, listener, world.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> packet, T listener, BlockableEventLoop<?> engine) throws RunningOnDifferentThreadException {
        if (!engine.isSameThread()) {
            engine.executeIfPossible(() -> {
                if (listener instanceof ServerCommonPacketListenerImpl) {
                    ServerCommonPacketListenerImpl serverCommonPacketListener = (ServerCommonPacketListenerImpl)listener;
                    if (serverCommonPacketListener.processedDisconnect) {
                        return;
                    }
                }
                if (listener.shouldHandleMessage(packet)) {
                    Timing timing = MinecraftTimings.getPacketTiming(packet);
                    try (Timing ignored = timing.startTiming();){
                        packet.handle(listener);
                    }
                    catch (Exception exception) {
                        ReportedException reportedexception;
                        if (exception instanceof ReportedException && (reportedexception = (ReportedException)exception).getCause() instanceof OutOfMemoryError) {
                            throw PacketUtils.makeReportedException(exception, packet, listener);
                        }
                        listener.onPacketError(packet, exception);
                    }
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)packet);
                }
            });
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception exception, Packet<T> packet, T listener) {
        if (exception instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)exception;
            PacketUtils.fillCrashReport(reportedexception.getReport(), listener, packet);
            return reportedexception;
        }
        CrashReport crashreport = CrashReport.forThrowable(exception, "Main thread packet handler");
        PacketUtils.fillCrashReport(crashreport, listener, packet);
        return new ReportedException(crashreport);
    }

    public static <T extends PacketListener> void fillCrashReport(CrashReport report, T listener, @Nullable Packet<T> packet) {
        if (packet != null) {
            CrashReportCategory crashreportsystemdetails = report.addCategory("Incoming Packet");
            crashreportsystemdetails.setDetail("Type", () -> packet.type().toString());
            crashreportsystemdetails.setDetail("Is Terminal", () -> Boolean.toString(packet.isTerminal()));
            crashreportsystemdetails.setDetail("Is Skippable", () -> Boolean.toString(packet.isSkippable()));
        }
        listener.fillCrashReport(report);
    }
}

