/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import javax.annotation.Nullable;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.level.ServerPlayer;

public interface OutgoingChatMessage {
    public Component content();

    public void sendToPlayer(ServerPlayer var1, boolean var2, ChatType.Bound var3);

    default public void sendToPlayer(ServerPlayer sender, boolean filterMaskEnabled, ChatType.Bound params, @Nullable Component unsigned) {
        this.sendToPlayer(sender, filterMaskEnabled, params);
    }

    public static OutgoingChatMessage create(PlayerChatMessage message) {
        return (OutgoingChatMessage)((Object)(message.isSystem() ? new Disguised(message.decoratedContent()) : new Player(message)));
    }

    public record Disguised(Component content) implements OutgoingChatMessage
    {
        @Override
        public void sendToPlayer(ServerPlayer sender, boolean filterMaskEnabled, ChatType.Bound params) {
            this.sendToPlayer(sender, filterMaskEnabled, params, null);
        }

        @Override
        public void sendToPlayer(ServerPlayer sender, boolean filterMaskEnabled, ChatType.Bound params, @Nullable Component unsigned) {
            sender.connection.sendDisguisedChatMessage(unsigned != null ? unsigned : this.content, params);
        }
    }

    public record Player(PlayerChatMessage message) implements OutgoingChatMessage
    {
        @Override
        public Component content() {
            return this.message.decoratedContent();
        }

        @Override
        public void sendToPlayer(ServerPlayer sender, boolean filterMaskEnabled, ChatType.Bound params) {
            this.sendToPlayer(sender, filterMaskEnabled, params, null);
        }

        @Override
        public void sendToPlayer(ServerPlayer sender, boolean filterMaskEnabled, ChatType.Bound params, @Nullable Component unsigned) {
            PlayerChatMessage playerChatMessage = this.message.filter(filterMaskEnabled);
            PlayerChatMessage playerChatMessage2 = playerChatMessage = unsigned != null ? playerChatMessage.withUnsignedContent(unsigned) : playerChatMessage;
            if (!playerChatMessage.isFullyFiltered()) {
                sender.connection.sendPlayerChatMessage(playerChatMessage, params);
            }
        }
    }
}

