/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComponentSerialization {
    public static final Codec<Component> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = ComponentSerialization.createTranslationAware(() -> NbtAccounter.create(0x200000L));
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final ThreadLocal<Boolean> DONT_RENDER_TRANSLATABLES = ThreadLocal.withInitial(() -> false);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> TRUSTED_STREAM_CODEC = ComponentSerialization.createTranslationAware(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, Component> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);
    public static final Codec<Component> FLAT_CODEC = ComponentSerialization.flatCodec(Integer.MAX_VALUE);
    private static final Map<Locale, Codec<Component>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, Codec<Component>>();

    private static StreamCodec<RegistryFriendlyByteBuf, Component> createTranslationAware(final Supplier<NbtAccounter> sizeTracker) {
        return new StreamCodec<RegistryFriendlyByteBuf, Component>(){
            final StreamCodec<ByteBuf, Tag> streamCodec;
            {
                this.streamCodec = ByteBufCodecs.tagCodec(sizeTracker);
            }

            @Override
            public Component decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                Tag tag = (Tag)this.streamCodec.decode(registryFriendlyByteBuf);
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return (Component)CODEC.parse(registryOps, (Object)tag).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(tag)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Component object) {
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag tag = (Tag)(DONT_RENDER_TRANSLATABLES.get() != false ? CODEC : ComponentSerialization.localizedCodec(registryFriendlyByteBuf.adventure$locale)).encodeStart(registryOps, (Object)object).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(object)));
                this.streamCodec.encode(registryFriendlyByteBuf, tag);
            }
        };
    }

    public static Codec<Component> flatCodec(int maxSerializedLength) {
        final Codec codec = Codec.string((int)0, (int)maxSerializedLength);
        return new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> dynamicOps, T object) {
                DynamicOps<JsonElement> dynamicOps2 = 2.asJsonOps(dynamicOps);
                return codec.decode(dynamicOps, object).flatMap(pair -> {
                    try {
                        JsonElement jsonElement = JsonParser.parseString((String)((String)pair.getFirst()));
                        return CODEC.parse(dynamicOps2, (Object)jsonElement).map(text -> Pair.of((Object)text, (Object)pair.getSecond()));
                    }
                    catch (JsonParseException var3x) {
                        return DataResult.error(var3x::getMessage);
                    }
                });
            }

            public <T> DataResult<T> encode(Component component, DynamicOps<T> dynamicOps, T object) {
                DynamicOps<JsonElement> dynamicOps2 = 2.asJsonOps(dynamicOps);
                return CODEC.encodeStart(dynamicOps2, (Object)component).flatMap(json -> {
                    try {
                        return codec.encodeStart(dynamicOps, (Object)GsonHelper.toStableString(json));
                    }
                    catch (IllegalArgumentException var4x) {
                        return DataResult.error(var4x::getMessage);
                    }
                });
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> ops) {
                Object object;
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    object = registryOps.withParent(JsonOps.INSTANCE);
                } else {
                    object = JsonOps.INSTANCE;
                }
                return object;
            }
        };
    }

    private static MutableComponent createFromList(List<Component> texts) {
        MutableComponent mutableComponent = texts.get(0).copy();
        for (int i = 1; i < texts.size(); ++i) {
            mutableComponent.append(texts.get(i));
        }
        return mutableComponent;
    }

    public static <T extends StringRepresentable, E> MapCodec<E> createLegacyComponentMatcher(T[] types, Function<T, MapCodec<? extends E>> typeToCodec, Function<E, T> valueToType, String dispatchingKey) {
        FuzzyCodec<Object> mapCodec = new FuzzyCodec<Object>(Stream.of(types).map(typeToCodec).toList(), object -> (MapEncoder)typeToCodec.apply((StringRepresentable)valueToType.apply(object)));
        Codec codec = StringRepresentable.fromValues(() -> types);
        MapCodec mapCodec2 = codec.dispatchMap(dispatchingKey, valueToType, typeToCodec);
        StrictEither<Object> mapCodec3 = new StrictEither<Object>(dispatchingKey, mapCodec2, mapCodec);
        return ExtraCodecs.orCompressed(mapCodec3, mapCodec2);
    }

    public static Codec<Component> localizedCodec(@Nullable Locale locale) {
        if (locale == null) {
            return CODEC;
        }
        return LOCALIZED_CODECS.computeIfAbsent(locale, loc -> Codec.recursive((String)"Component", selfCodec -> ComponentSerialization.createCodec((Codec<Component>)selfCodec, loc)));
    }

    private static Codec<Component> createCodec(Codec<Component> selfCodec) {
        return ComponentSerialization.createCodec(selfCodec, null);
    }

    private static Codec<Component> createCodec(Codec<Component> selfCodec, final @javax.annotation.Nullable Locale locale) {
        Codec codec;
        StringRepresentable[] types = new ComponentContents.Type[]{PlainTextContents.TYPE, TranslatableContents.TYPE, KeybindContents.TYPE, ScoreContents.TYPE, SelectorContents.TYPE, NbtContents.TYPE};
        MapCodec mapCodec = ComponentSerialization.createLegacyComponentMatcher((StringRepresentable[])types, ComponentContents.Type::codec, ComponentContents::type, (String)"type");
        final Codec origCodec = codec = RecordCodecBuilder.create(instance -> instance.group((App)mapCodec.forGetter(Component::getContents), (App)ExtraCodecs.nonEmptyList(selfCodec.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::getSiblings), (App)Style.Serializer.MAP_CODEC.forGetter(Component::getStyle)).apply((Applicative)instance, MutableComponent::new));
        codec = new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> ops, T input) {
                return origCodec.decode(ops, input);
            }

            public <T> DataResult<T> encode(Component input, DynamicOps<T> ops, T prefix) {
                net.kyori.adventure.text.Component adventureComponent;
                if (input instanceof AdventureComponent) {
                    AdventureComponent adv = (AdventureComponent)input;
                    adventureComponent = adv.adventure$component();
                } else if (locale != null && input.getContents() instanceof TranslatableContents && PaperAdventure.hasAnyTranslations()) {
                    adventureComponent = PaperAdventure.asAdventure(input);
                } else {
                    return origCodec.encode((Object)input, ops, prefix);
                }
                return PaperAdventure.localizedCodec(locale).encode((Object)adventureComponent, ops, prefix);
            }

            public String toString() {
                return origCodec.toString() + "[AdventureComponentAware]";
            }
        };
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(selfCodec.listOf())), (Codec)codec).xmap(either -> either.map(either2 -> either2.map(Component::literal, ComponentSerialization::createFromList), text -> text), text -> {
            String string = text.tryCollapseToString();
            return string != null ? Either.left(Either.left(string)) : Either.right(text);
        });
    }

    static class FuzzyCodec<T>
    extends MapCodec<T> {
        private final List<MapCodec<? extends T>> codecs;
        private final Function<T, MapEncoder<? extends T>> encoderGetter;

        public FuzzyCodec(List<MapCodec<? extends T>> codecs, Function<T, MapEncoder<? extends T>> codecGetter) {
            this.codecs = codecs;
            this.encoderGetter = codecGetter;
        }

        public <S> DataResult<T> decode(DynamicOps<S> dynamicOps, MapLike<S> mapLike) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult dataResult = mapDecoder.decode(dynamicOps, mapLike);
                if (!dataResult.result().isPresent()) continue;
                return dataResult;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T object, DynamicOps<S> dynamicOps, RecordBuilder<S> recordBuilder) {
            MapEncoder<? extends T> mapEncoder = this.encoderGetter.apply(object);
            return mapEncoder.encode(object, dynamicOps, recordBuilder);
        }

        public <S> Stream<S> keys(DynamicOps<S> dynamicOps) {
            return this.codecs.stream().flatMap(codec -> codec.keys(dynamicOps)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class StrictEither<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public StrictEither(String dispatchingKey, MapCodec<T> withKeyCodec, MapCodec<T> withoutKeyCodec) {
            this.typeFieldName = dispatchingKey;
            this.typed = withKeyCodec;
            this.fuzzy = withoutKeyCodec;
        }

        public <O> DataResult<T> decode(DynamicOps<O> dynamicOps, MapLike<O> mapLike) {
            return mapLike.get(this.typeFieldName) != null ? this.typed.decode(dynamicOps, mapLike) : this.fuzzy.decode(dynamicOps, mapLike);
        }

        public <O> RecordBuilder<O> encode(T object, DynamicOps<O> dynamicOps, RecordBuilder<O> recordBuilder) {
            return this.fuzzy.encode(object, dynamicOps, recordBuilder);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> dynamicOps) {
            return Stream.concat(this.typed.keys(dynamicOps), this.fuzzy.keys(dynamicOps)).distinct();
        }
    }
}

