/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.VarInt;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    private static final int MAX_VARINT21_BYTES = 3;
    private final ByteBuf helperBuf = Unpooled.directBuffer((int)3);
    @Nullable
    private final BandwidthDebugMonitor monitor;

    public Varint21FrameDecoder(@Nullable BandwidthDebugMonitor packetSizeLogger) {
        this.monitor = packetSizeLogger;
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.helperBuf.release();
    }

    private static boolean copyVarint(ByteBuf source, ByteBuf sizeBuf) {
        for (int i = 0; i < 3; ++i) {
            if (!source.isReadable()) {
                return false;
            }
            byte b = source.readByte();
            sizeBuf.writeByte((int)b);
            if (VarInt.hasContinuationBit(b)) continue;
            return true;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }

    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!channelHandlerContext.channel().isActive()) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        byteBuf.markReaderIndex();
        this.helperBuf.clear();
        if (!Varint21FrameDecoder.copyVarint(byteBuf, this.helperBuf)) {
            byteBuf.resetReaderIndex();
        } else {
            int i = VarInt.read(this.helperBuf);
            if (byteBuf.readableBytes() < i) {
                byteBuf.resetReaderIndex();
            } else {
                if (this.monitor != null) {
                    this.monitor.onReceive(i + VarInt.getByteSize(i));
                }
                list.add(byteBuf.readBytes(i));
            }
        }
    }
}

