/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> InboundConfigurationTask setupInboundProtocol(ProtocolInfo<T> newState) {
        return UnconfiguredPipelineHandler.setupInboundHandler(new PacketDecoder<T>(newState));
    }

    private static InboundConfigurationTask setupInboundHandler(ChannelInboundHandler newDecoder) {
        return context -> {
            context.pipeline().replace(context.name(), "decoder", (ChannelHandler)newDecoder);
            context.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> OutboundConfigurationTask setupOutboundProtocol(ProtocolInfo<T> newState) {
        return UnconfiguredPipelineHandler.setupOutboundHandler(new PacketEncoder<T>(newState));
    }

    private static OutboundConfigurationTask setupOutboundHandler(ChannelOutboundHandler newEncoder) {
        return context -> context.pipeline().replace(context.name(), "encoder", (ChannelHandler)newEncoder);
    }

    @FunctionalInterface
    public static interface InboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public InboundConfigurationTask andThen(InboundConfigurationTask inboundConfigurationTask) {
            return context -> {
                this.run(context);
                inboundConfigurationTask.run(context);
            };
        }
    }

    @FunctionalInterface
    public static interface OutboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public OutboundConfigurationTask andThen(OutboundConfigurationTask outboundConfigurationTask) {
            return context -> {
                this.run(context);
                outboundConfigurationTask.run(context);
            };
        }
    }

    public static class Outbound
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            if (object instanceof Packet) {
                ReferenceCountUtil.release((Object)object);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(object));
            }
            if (object instanceof OutboundConfigurationTask) {
                OutboundConfigurationTask outboundConfigurationTask = (OutboundConfigurationTask)object;
                try {
                    outboundConfigurationTask.run(channelHandlerContext);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
                channelPromise.setSuccess();
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
        }
    }

    public static class Inbound
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            if (object instanceof ByteBuf || object instanceof Packet) {
                ReferenceCountUtil.release((Object)object);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(object));
            }
            channelHandlerContext.fireChannelRead(object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
            if (object instanceof InboundConfigurationTask) {
                InboundConfigurationTask inboundConfigurationTask = (InboundConfigurationTask)object;
                try {
                    inboundConfigurationTask.run(channelHandlerContext);
                }
                finally {
                    ReferenceCountUtil.release((Object)object);
                }
                channelPromise.setSuccess();
            } else {
                channelHandlerContext.write(object, channelPromise);
            }
        }
    }
}

