/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagVisitor;

public class StringTagVisitor
implements TagVisitor {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private final StringBuilder builder = new StringBuilder();

    public String visit(Tag element) {
        element.accept(this);
        return this.builder.toString();
    }

    @Override
    @Override
    public void visitString(StringTag element) {
        this.builder.append(StringTag.quoteAndEscape(element.getAsString()));
    }

    @Override
    @Override
    public void visitByte(ByteTag element) {
        this.builder.append(element.getAsNumber()).append('b');
    }

    @Override
    @Override
    public void visitShort(ShortTag element) {
        this.builder.append(element.getAsNumber()).append('s');
    }

    @Override
    @Override
    public void visitInt(IntTag element) {
        this.builder.append(element.getAsNumber());
    }

    @Override
    @Override
    public void visitLong(LongTag element) {
        this.builder.append(element.getAsNumber()).append('L');
    }

    @Override
    @Override
    public void visitFloat(FloatTag element) {
        this.builder.append(element.getAsFloat()).append('f');
    }

    @Override
    @Override
    public void visitDouble(DoubleTag element) {
        this.builder.append(element.getAsDouble()).append('d');
    }

    @Override
    @Override
    public void visitByteArray(ByteArrayTag element) {
        this.builder.append("[B;");
        byte[] bs = element.getAsByteArray();
        for (int i = 0; i < bs.length; ++i) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(bs[i]).append('B');
        }
        this.builder.append(']');
    }

    @Override
    @Override
    public void visitIntArray(IntArrayTag element) {
        this.builder.append("[I;");
        int[] is = element.getAsIntArray();
        for (int i = 0; i < is.length; ++i) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(is[i]);
        }
        this.builder.append(']');
    }

    @Override
    @Override
    public void visitLongArray(LongArrayTag element) {
        this.builder.append("[L;");
        long[] ls = element.getAsLongArray();
        for (int i = 0; i < ls.length; ++i) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(ls[i]).append('L');
        }
        this.builder.append(']');
    }

    @Override
    @Override
    public void visitList(ListTag element) {
        this.builder.append('[');
        for (int i = 0; i < element.size(); ++i) {
            if (i != 0) {
                this.builder.append(',');
            }
            this.builder.append(new StringTagVisitor().visit(element.get(i)));
        }
        this.builder.append(']');
    }

    @Override
    @Override
    public void visitCompound(CompoundTag compound) {
        this.builder.append('{');
        ArrayList list = Lists.newArrayList(compound.getAllKeys());
        Collections.sort(list);
        for (String string : list) {
            if (this.builder.length() != 1) {
                this.builder.append(',');
            }
            this.builder.append(StringTagVisitor.handleEscape(string)).append(':').append(new StringTagVisitor().visit(compound.get(string)));
        }
        this.builder.append('}');
    }

    protected static String handleEscape(String name) {
        if (SIMPLE_VALUE.matcher(name).matches()) {
            return name;
        }
        return StringTag.quoteAndEscape(name);
    }

    @Override
    @Override
    public void visitEnd(EndTag element) {
        this.builder.append("END");
    }
}

