/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagVisitor;

public class IntTag
extends NumericTag {
    private static final int SELF_SIZE_IN_BYTES = 12;
    public static final TagType<IntTag> TYPE = new TagType.StaticSize<IntTag>(){

        @Override
        @Override
        public IntTag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return IntTag.valueOf(1.readAccounted(dataInput, nbtAccounter));
        }

        @Override
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput input, StreamTagVisitor visitor, NbtAccounter tracker) throws IOException {
            return visitor.visit(1.readAccounted(input, tracker));
        }

        private static int readAccounted(DataInput input, NbtAccounter tracker) throws IOException {
            tracker.accountBytes(12L);
            return input.readInt();
        }

        @Override
        @Override
        public int size() {
            return 4;
        }

        @Override
        @Override
        public String getName() {
            return "INT";
        }

        @Override
        @Override
        public String getPrettyName() {
            return "TAG_Int";
        }

        @Override
        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ Tag load(DataInput input, NbtAccounter tracker) throws IOException {
            return this.load(input, tracker);
        }
    };
    private final int data;

    IntTag(int value) {
        this.data = value;
    }

    public static IntTag valueOf(int value) {
        if (value >= -128 && value <= 1024) {
            return Cache.cache[value - -128];
        }
        return new IntTag(value);
    }

    @Override
    @Override
    public void write(DataOutput output) throws IOException {
        output.writeInt(this.data);
    }

    @Override
    @Override
    public int sizeInBytes() {
        return 12;
    }

    @Override
    @Override
    public byte getId() {
        return 3;
    }

    @Override
    public TagType<IntTag> getType() {
        return TYPE;
    }

    @Override
    @Override
    public IntTag copy() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof IntTag && this.data == ((IntTag)object).data;
    }

    @Override
    public int hashCode() {
        return this.data;
    }

    @Override
    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitInt(this);
    }

    @Override
    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    @Override
    public int getAsInt() {
        return this.data;
    }

    @Override
    @Override
    public short getAsShort() {
        return (short)(this.data & 0xFFFF);
    }

    @Override
    @Override
    public byte getAsByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor visitor) {
        return visitor.visit(this.data);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }

    static class Cache {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final IntTag[] cache = new IntTag[1153];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new IntTag(-128 + i);
            }
        }
    }
}

