/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class TerrainProvider {
    private static final float DEEP_OCEAN_CONTINENTALNESS = -0.51f;
    private static final float OCEAN_CONTINENTALNESS = -0.4f;
    private static final float PLAINS_CONTINENTALNESS = 0.1f;
    private static final float BEACH_CONTINENTALNESS = -0.15f;
    private static final ToFloatFunction<Float> NO_TRANSFORM = ToFloatFunction.IDENTITY;
    private static final ToFloatFunction<Float> AMPLIFIED_OFFSET = ToFloatFunction.createUnlimited(value -> value < 0.0f ? value : value * 2.0f);
    private static final ToFloatFunction<Float> AMPLIFIED_FACTOR = ToFloatFunction.createUnlimited(value -> 1.25f - 6.25f / (value + 5.0f));
    private static final ToFloatFunction<Float> AMPLIFIED_JAGGEDNESS = ToFloatFunction.createUnlimited(value -> value * 2.0f);

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldOffset(I continents, I erosion, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? AMPLIFIED_OFFSET : NO_TRANSFORM;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, toFloatFunction);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, toFloatFunction);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, toFloatFunction);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.buildErosionOffsetSpline(erosion, ridgesFolded, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, toFloatFunction);
        return CubicSpline.builder(continents, toFloatFunction).addPoint(-1.1f, 0.044f).addPoint(-1.02f, -0.2222f).addPoint(-0.51f, -0.2222f).addPoint(-0.44f, -0.12f).addPoint(-0.18f, -0.12f).addPoint(-0.16f, cubicSpline).addPoint(-0.15f, cubicSpline).addPoint(-0.1f, cubicSpline2).addPoint(0.25f, cubicSpline3).addPoint(1.0f, cubicSpline4).build();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldFactor(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? AMPLIFIED_FACTOR : NO_TRANSFORM;
        return CubicSpline.builder(continents, NO_TRANSFORM).addPoint(-0.19f, 3.95f).addPoint(-0.15f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 6.25f, true, NO_TRANSFORM)).addPoint(-0.1f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 5.47f, true, toFloatFunction)).addPoint(0.03f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 5.08f, true, toFloatFunction)).addPoint(0.06f, TerrainProvider.getErosionFactor(erosion, ridges, ridgesFolded, 4.69f, false, toFloatFunction)).build();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> overworldJaggedness(I continents, I erosion, I ridges, I ridgesFolded, boolean amplified) {
        ToFloatFunction<Float> toFloatFunction = amplified ? AMPLIFIED_JAGGEDNESS : NO_TRANSFORM;
        float f = 0.65f;
        return CubicSpline.builder(continents, toFloatFunction).addPoint(-0.11f, 0.0f).addPoint(0.03f, TerrainProvider.buildErosionJaggednessSpline(erosion, ridges, ridgesFolded, 1.0f, 0.5f, 0.0f, 0.0f, toFloatFunction)).addPoint(0.65f, TerrainProvider.buildErosionJaggednessSpline(erosion, ridges, ridgesFolded, 1.0f, 1.0f, 1.0f, 0.0f, toFloatFunction)).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I erosion, I ridges, I ridgesFolded, float f, float g, float h, float i, ToFloatFunction<Float> amplifier) {
        float j = -0.5775f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildRidgeJaggednessSpline(ridges, ridgesFolded, f, h, amplifier);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.buildRidgeJaggednessSpline(ridges, ridgesFolded, g, i, amplifier);
        return CubicSpline.builder(erosion, amplifier).addPoint(-1.0f, cubicSpline).addPoint(-0.78f, cubicSpline2).addPoint(-0.5775f, cubicSpline2).addPoint(-0.375f, 0.0f).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I ridges, I ridgesFolded, float f, float g, ToFloatFunction<Float> amplifier) {
        float h = NoiseRouterData.peaksAndValleys(0.4f);
        float i = NoiseRouterData.peaksAndValleys(0.56666666f);
        float j = (h + i) / 2.0f;
        CubicSpline.Builder<C, I> builder = CubicSpline.builder(ridgesFolded, amplifier);
        builder.addPoint(h, 0.0f);
        if (g > 0.0f) {
            builder.addPoint(j, TerrainProvider.buildWeirdnessJaggednessSpline(ridges, g, amplifier));
        } else {
            builder.addPoint(j, 0.0f);
        }
        if (f > 0.0f) {
            builder.addPoint(1.0f, TerrainProvider.buildWeirdnessJaggednessSpline(ridges, f, amplifier));
        } else {
            builder.addPoint(1.0f, 0.0f);
        }
        return builder.build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I ridges, float f, ToFloatFunction<Float> amplifier) {
        float g = 0.63f * f;
        float h = 0.3f * f;
        return CubicSpline.builder(ridges, amplifier).addPoint(-0.01f, g).addPoint(0.01f, h).build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I erosion, I ridges, I ridgesFolded, float f, boolean bl, ToFloatFunction<Float> amplifier) {
        CubicSpline cubicSpline = CubicSpline.builder(ridges, amplifier).addPoint(-0.2f, 6.3f).addPoint(0.2f, f).build();
        CubicSpline.Builder builder = CubicSpline.builder(erosion, amplifier).addPoint(-0.6f, cubicSpline).addPoint(-0.5f, CubicSpline.builder(ridges, amplifier).addPoint(-0.05f, 6.3f).addPoint(0.05f, 2.67f).build()).addPoint(-0.35f, cubicSpline).addPoint(-0.25f, cubicSpline).addPoint(-0.1f, CubicSpline.builder(ridges, amplifier).addPoint(-0.05f, 2.67f).addPoint(0.05f, 6.3f).build()).addPoint(0.03f, cubicSpline);
        if (bl) {
            CubicSpline cubicSpline2 = CubicSpline.builder(ridges, amplifier).addPoint(0.0f, f).addPoint(0.1f, 0.625f).build();
            CubicSpline cubicSpline3 = CubicSpline.builder(ridgesFolded, amplifier).addPoint(-0.9f, f).addPoint(-0.69f, cubicSpline2).build();
            builder.addPoint(0.35f, f).addPoint(0.45f, cubicSpline3).addPoint(0.55f, cubicSpline3).addPoint(0.62f, f);
        } else {
            CubicSpline cubicSpline4 = CubicSpline.builder(ridgesFolded, amplifier).addPoint(-0.7f, cubicSpline).addPoint(-0.15f, 1.37f).build();
            CubicSpline cubicSpline5 = CubicSpline.builder(ridgesFolded, amplifier).addPoint(0.45f, cubicSpline).addPoint(0.7f, 1.56f).build();
            builder.addPoint(0.05f, cubicSpline5).addPoint(0.4f, cubicSpline5).addPoint(0.45f, cubicSpline4).addPoint(0.55f, cubicSpline4).addPoint(0.58f, f);
        }
        return builder.build();
    }

    private static float calculateSlope(float f, float g, float h, float i) {
        return (g - f) / (i - h);
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I ridgesFolded, float f, boolean bl, ToFloatFunction<Float> amplifier) {
        CubicSpline.Builder builder = CubicSpline.builder(ridgesFolded, amplifier);
        float g = -0.7f;
        float h = -1.0f;
        float i = TerrainProvider.mountainContinentalness(-1.0f, f, -0.7f);
        float j = 1.0f;
        float k = TerrainProvider.mountainContinentalness(1.0f, f, -0.7f);
        float l = TerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(f);
        float m = -0.65f;
        if (-0.65f < l && l < 1.0f) {
            float n = TerrainProvider.mountainContinentalness(-0.65f, f, -0.7f);
            float o = -0.75f;
            float p = TerrainProvider.mountainContinentalness(-0.75f, f, -0.7f);
            float q = TerrainProvider.calculateSlope(i, p, -1.0f, -0.75f);
            builder.addPoint(-1.0f, i, q);
            builder.addPoint(-0.75f, p);
            builder.addPoint(-0.65f, n);
            float r = TerrainProvider.mountainContinentalness(l, f, -0.7f);
            float s = TerrainProvider.calculateSlope(r, k, l, 1.0f);
            float t = 0.01f;
            builder.addPoint(l - 0.01f, r);
            builder.addPoint(l, r, s);
            builder.addPoint(1.0f, k, s);
        } else {
            float u = TerrainProvider.calculateSlope(i, k, -1.0f, 1.0f);
            if (bl) {
                builder.addPoint(-1.0f, Math.max(0.2f, i));
                builder.addPoint(0.0f, Mth.lerp(0.5f, i, k), u);
            } else {
                builder.addPoint(-1.0f, i, u);
            }
            builder.addPoint(1.0f, k, u);
        }
        return builder.build();
    }

    private static float mountainContinentalness(float f, float g, float h) {
        float i = 1.17f;
        float j = 0.46082947f;
        float k = 1.0f - (1.0f - g) * 0.5f;
        float l = 0.5f * (1.0f - g);
        float m = (f + 1.17f) * 0.46082947f;
        float n = m * k - l;
        if (f < h) {
            return Math.max(n, -0.2222f);
        }
        return Math.max(n, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float f) {
        float g = 1.17f;
        float h = 0.46082947f;
        float i = 1.0f - (1.0f - f) * 0.5f;
        float j = 0.5f * (1.0f - f);
        return j / (0.46082947f * i) - 1.17f;
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I erosion, I ridgesFolded, float continentalness, float f, float g, float h, float i, float j, boolean bl, boolean bl2, ToFloatFunction<Float> amplifier) {
        float k = 0.6f;
        float l = 0.5f;
        float m = 0.5f;
        CubicSpline<C, I> cubicSpline = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, Mth.lerp(h, 0.6f, 1.5f), bl2, amplifier);
        CubicSpline<C, I> cubicSpline2 = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, Mth.lerp(h, 0.6f, 1.0f), bl2, amplifier);
        CubicSpline<C, I> cubicSpline3 = TerrainProvider.buildMountainRidgeSplineWithPoints(ridgesFolded, h, bl2, amplifier);
        CubicSpline<C, I> cubicSpline4 = TerrainProvider.ridgeSpline(ridgesFolded, continentalness - 0.15f, 0.5f * h, Mth.lerp(0.5f, 0.5f, 0.5f) * h, 0.5f * h, 0.6f * h, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline5 = TerrainProvider.ridgeSpline(ridgesFolded, continentalness, i * h, f * h, 0.5f * h, 0.6f * h, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline6 = TerrainProvider.ridgeSpline(ridgesFolded, continentalness, i, i, f, g, 0.5f, amplifier);
        CubicSpline<C, I> cubicSpline7 = TerrainProvider.ridgeSpline(ridgesFolded, continentalness, i, i, f, g, 0.5f, amplifier);
        CubicSpline cubicSpline8 = CubicSpline.builder(ridgesFolded, amplifier).addPoint(-1.0f, continentalness).addPoint(-0.4f, cubicSpline6).addPoint(0.0f, g + 0.07f).build();
        CubicSpline<C, I> cubicSpline9 = TerrainProvider.ridgeSpline(ridgesFolded, -0.02f, j, j, f, g, 0.0f, amplifier);
        CubicSpline.Builder<C, I> builder = CubicSpline.builder(erosion, amplifier).addPoint(-0.85f, cubicSpline).addPoint(-0.7f, cubicSpline2).addPoint(-0.4f, cubicSpline3).addPoint(-0.35f, cubicSpline4).addPoint(-0.1f, cubicSpline5).addPoint(0.2f, cubicSpline6);
        if (bl) {
            builder.addPoint(0.4f, cubicSpline7).addPoint(0.45f, cubicSpline8).addPoint(0.55f, cubicSpline8).addPoint(0.58f, cubicSpline7);
        }
        builder.addPoint(0.7f, cubicSpline9);
        return builder.build();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I ridgesFolded, float continentalness, float f, float g, float h, float i, float j, ToFloatFunction<Float> amplifier) {
        float k = Math.max(0.5f * (f - continentalness), j);
        float l = 5.0f * (g - f);
        return CubicSpline.builder(ridgesFolded, amplifier).addPoint(-1.0f, continentalness, k).addPoint(-0.4f, f, Math.min(k, l)).addPoint(0.0f, g, l).addPoint(0.4f, h, 2.0f * (h - g)).addPoint(1.0f, i, 0.7f * (i - h)).build();
    }
}

