/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.models.blockstates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class MultiPartGenerator
implements BlockStateGenerator {
    private final Block block;
    private final List<Entry> parts = Lists.newArrayList();

    private MultiPartGenerator(Block block) {
        this.block = block;
    }

    @Override
    @Override
    public Block getBlock() {
        return this.block;
    }

    public static MultiPartGenerator multiPart(Block block) {
        return new MultiPartGenerator(block);
    }

    public MultiPartGenerator with(List<Variant> variants) {
        this.parts.add(new Entry(variants));
        return this;
    }

    public MultiPartGenerator with(Variant variant) {
        return this.with((List<Variant>)ImmutableList.of((Object)variant));
    }

    public MultiPartGenerator with(Condition condition, List<Variant> variants) {
        this.parts.add(new ConditionalEntry(condition, variants));
        return this;
    }

    public MultiPartGenerator with(Condition condition, Variant ... variants) {
        return this.with(condition, (List<Variant>)ImmutableList.copyOf((Object[])variants));
    }

    public MultiPartGenerator with(Condition condition, Variant variant) {
        return this.with(condition, (List<Variant>)ImmutableList.of((Object)variant));
    }

    @Override
    @Override
    public JsonElement get() {
        StateDefinition<Block, BlockState> stateDefinition = this.block.getStateDefinition();
        this.parts.forEach(multipart -> multipart.validate(stateDefinition));
        JsonArray jsonArray = new JsonArray();
        this.parts.stream().map(Entry::get).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("multipart", (JsonElement)jsonArray);
        return jsonObject;
    }

    @Override
    public /* synthetic */ Object get() {
        return this.get();
    }

    static class Entry
    implements Supplier<JsonElement> {
        private final List<Variant> variants;

        Entry(List<Variant> variants) {
            this.variants = variants;
        }

        public void validate(StateDefinition<?, ?> stateManager) {
        }

        public void decorate(JsonObject json) {
        }

        @Override
        @Override
        public JsonElement get() {
            JsonObject jsonObject = new JsonObject();
            this.decorate(jsonObject);
            jsonObject.add("apply", Variant.convertList(this.variants));
            return jsonObject;
        }

        @Override
        public /* synthetic */ Object get() {
            return this.get();
        }
    }

    static class ConditionalEntry
    extends Entry {
        private final Condition condition;

        ConditionalEntry(Condition when, List<Variant> variants) {
            super(variants);
            this.condition = when;
        }

        @Override
        @Override
        public void validate(StateDefinition<?, ?> stateManager) {
            this.condition.validate(stateManager);
        }

        @Override
        @Override
        public void decorate(JsonObject json) {
            json.add("when", (JsonElement)this.condition.get());
        }
    }
}

