/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.KnownPack;

public class RegistrySynchronization {
    public static final Set<ResourceKey<? extends Registry<?>>> NETWORKABLE_REGISTRIES = RegistryDataLoader.SYNCHRONIZED_REGISTRIES.stream().map(RegistryDataLoader.RegistryData::key).collect(Collectors.toUnmodifiableSet());

    public static void packRegistries(DynamicOps<Tag> nbtOps, RegistryAccess registryManager, Set<KnownPack> knownPacks, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> callback) {
        RegistryDataLoader.SYNCHRONIZED_REGISTRIES.forEach(registry -> RegistrySynchronization.packRegistry(nbtOps, registry, registryManager, knownPacks, callback));
    }

    private static <T> void packRegistry(DynamicOps<Tag> nbtOps, RegistryDataLoader.RegistryData<T> entry, RegistryAccess registryManager, Set<KnownPack> knownPacks, BiConsumer<ResourceKey<? extends Registry<?>>, List<PackedRegistryEntry>> callback) {
        registryManager.registry(entry.key()).ifPresent(registry -> {
            ArrayList list = new ArrayList(registry.size());
            registry.holders().forEach(registryEntry -> {
                Optional<Tag> optional2;
                boolean bl = registry.registrationInfo(registryEntry.key()).flatMap(RegistrationInfo::knownPackInfo).filter(knownPacks::contains).isPresent();
                if (bl) {
                    Optional optional = Optional.empty();
                } else {
                    Tag tag = (Tag)entry.elementCodec().encodeStart(nbtOps, registryEntry.value()).getOrThrow(error -> new IllegalArgumentException("Failed to serialize " + String.valueOf(registryEntry.key()) + ": " + error));
                    optional2 = Optional.of(tag);
                }
                list.add(new PackedRegistryEntry(registryEntry.key().location(), optional2));
            });
            callback.accept(registry.key(), list);
        });
    }

    private static Stream<RegistryAccess.RegistryEntry<?>> ownedNetworkableRegistries(RegistryAccess dynamicRegistryManager) {
        return dynamicRegistryManager.registries().filter(registry -> NETWORKABLE_REGISTRIES.contains(registry.key()));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> combinedRegistries) {
        return RegistrySynchronization.ownedNetworkableRegistries(combinedRegistries.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<RegistryAccess.RegistryEntry<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> combinedRegistries) {
        Stream<RegistryAccess.RegistryEntry<?>> stream = combinedRegistries.getLayer(RegistryLayer.STATIC).registries();
        Stream<RegistryAccess.RegistryEntry<?>> stream2 = RegistrySynchronization.networkedRegistries(combinedRegistries);
        return Stream.concat(stream2, stream);
    }

    public record PackedRegistryEntry(ResourceLocation id, Optional<Tag> data) {
        public static final StreamCodec<ByteBuf, PackedRegistryEntry> STREAM_CODEC = StreamCodec.composite(ResourceLocation.STREAM_CODEC, PackedRegistryEntry::id, ByteBufCodecs.TAG.apply(ByteBufCodecs::optional), PackedRegistryEntry::data, PackedRegistryEntry::new);
    }
}

