/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.VisibleForTesting;

public interface HolderSet<T>
extends Iterable<Holder<T>> {
    public Stream<Holder<T>> stream();

    public int size();

    public Either<TagKey<T>, List<Holder<T>>> unwrap();

    public Optional<Holder<T>> getRandomElement(RandomSource var1);

    public Holder<T> get(int var1);

    public boolean contains(Holder<T> var1);

    public boolean canSerializeIn(HolderOwner<T> var1);

    public Optional<TagKey<T>> unwrapKey();

    @Deprecated
    @VisibleForTesting
    public static <T> Named<T> emptyNamed(HolderOwner<T> owner, TagKey<T> tagKey) {
        return new Named<T>((HolderOwner)owner, (TagKey)tagKey){

            @Override
            @Override
            protected List<Holder<T>> contents() {
                throw new UnsupportedOperationException("Tag " + String.valueOf(this.key()) + " can't be dereferenced during construction");
            }
        };
    }

    public static <T> HolderSet<T> empty() {
        return Direct.EMPTY;
    }

    @SafeVarargs
    public static <T> Direct<T> direct(Holder<T> ... entries) {
        return new Direct<T>(List.of(entries));
    }

    public static <T> Direct<T> direct(List<? extends Holder<T>> entries) {
        return new Direct(List.copyOf(entries));
    }

    @SafeVarargs
    public static <E, T> Direct<T> direct(Function<E, Holder<T>> mapper, E ... values) {
        return HolderSet.direct(Stream.of(values).map(mapper).toList());
    }

    public static <E, T> Direct<T> direct(Function<E, Holder<T>> mapper, Collection<E> values) {
        return HolderSet.direct(values.stream().map(mapper).toList());
    }

    public static final class Direct<T>
    extends ListBacked<T> {
        static final Direct<?> EMPTY = new Direct(List.of());
        private final List<Holder<T>> contents;
        @Nullable
        private Set<Holder<T>> contentsSet;

        Direct(List<Holder<T>> entries) {
            this.contents = entries;
        }

        @Override
        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.right(this.contents);
        }

        @Override
        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.empty();
        }

        @Override
        @Override
        public boolean contains(Holder<T> entry) {
            if (this.contentsSet == null) {
                this.contentsSet = Set.copyOf(this.contents);
            }
            return this.contentsSet.contains(entry);
        }

        @Override
        public String toString() {
            return "DirectSet[" + String.valueOf(this.contents) + "]";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Direct)) return false;
            Direct direct = (Direct)object;
            if (!this.contents.equals(direct.contents)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.contents.hashCode();
        }
    }

    public static class Named<T>
    extends ListBacked<T> {
        private final HolderOwner<T> owner;
        private final TagKey<T> key;
        private List<Holder<T>> contents = List.of();

        Named(HolderOwner<T> owner, TagKey<T> tag) {
            this.owner = owner;
            this.key = tag;
        }

        void bind(List<Holder<T>> entries) {
            this.contents = List.copyOf(entries);
        }

        public TagKey<T> key() {
            return this.key;
        }

        @Override
        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.of(this.key);
        }

        @Override
        @Override
        public boolean contains(Holder<T> entry) {
            return entry.is(this.key);
        }

        @Override
        public String toString() {
            return "NamedSet(" + String.valueOf(this.key) + ")[" + String.valueOf(this.contents) + "]";
        }

        @Override
        @Override
        public boolean canSerializeIn(HolderOwner<T> owner) {
            return this.owner.canSerializeIn(owner);
        }
    }

    public static abstract class ListBacked<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> contents();

        @Override
        @Override
        public int size() {
            return this.contents().size();
        }

        @Override
        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.contents().spliterator();
        }

        @Override
        @Override
        public Iterator<Holder<T>> iterator() {
            return this.contents().iterator();
        }

        @Override
        @Override
        public Stream<Holder<T>> stream() {
            return this.contents().stream();
        }

        @Override
        @Override
        public Optional<Holder<T>> getRandomElement(RandomSource random) {
            return Util.getRandomSafe(this.contents(), random);
        }

        @Override
        @Override
        public Holder<T> get(int index) {
            return this.contents().get(index);
        }

        @Override
        @Override
        public boolean canSerializeIn(HolderOwner<T> owner) {
            return true;
        }
    }
}

