/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization.brigadier;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class StringArgumentSerializer
implements ArgumentTypeInfo<StringArgumentType, Template> {
    @Override
    @Override
    public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
        buf.writeEnum((Enum<?>)properties.type);
    }

    @Override
    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        StringArgumentType.StringType stringType = friendlyByteBuf.readEnum(StringArgumentType.StringType.class);
        return new Template(stringType);
    }

    @Override
    @Override
    public void serializeToJson(Template properties, JsonObject json) {
        json.addProperty("type", switch (properties.type) {
            default -> throw new MatchException(null, null);
            case StringArgumentType.StringType.SINGLE_WORD -> "word";
            case StringArgumentType.StringType.QUOTABLE_PHRASE -> "phrase";
            case StringArgumentType.StringType.GREEDY_PHRASE -> "greedy";
        });
    }

    @Override
    @Override
    public Template unpack(StringArgumentType argumentType) {
        return new Template(argumentType.getType());
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
        return this.deserializeFromNetwork(buf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<StringArgumentType> {
        final StringArgumentType.StringType type;

        public Template(StringArgumentType.StringType type) {
            this.type = type;
        }

        @Override
        @Override
        public StringArgumentType instantiate(CommandBuildContext commandBuildContext) {
            return switch (this.type) {
                default -> throw new MatchException(null, null);
                case StringArgumentType.StringType.SINGLE_WORD -> StringArgumentType.word();
                case StringArgumentType.StringType.QUOTABLE_PHRASE -> StringArgumentType.string();
                case StringArgumentType.StringType.GREEDY_PHRASE -> StringArgumentType.greedyString();
            };
        }

        @Override
        @Override
        public ArgumentTypeInfo<StringArgumentType, ?> type() {
            return StringArgumentSerializer.this;
        }

        @Override
        public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandRegistryAccess) {
            return this.instantiate(commandRegistryAccess);
        }
    }
}

