/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class SingletonArgumentInfo<A extends ArgumentType<?>>
implements ArgumentTypeInfo<A, Template> {
    private final Template template;

    private SingletonArgumentInfo(Function<CommandBuildContext, A> typeSupplier) {
        this.template = new Template(typeSupplier);
    }

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> contextFree(Supplier<T> typeSupplier) {
        return new SingletonArgumentInfo<ArgumentType>(commandRegistryAccess -> (ArgumentType)typeSupplier.get());
    }

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> contextAware(Function<CommandBuildContext, T> typeSupplier) {
        return new SingletonArgumentInfo<T>(typeSupplier);
    }

    @Override
    @Override
    public void serializeToNetwork(Template properties, FriendlyByteBuf buf) {
    }

    @Override
    @Override
    public void serializeToJson(Template properties, JsonObject json) {
    }

    @Override
    @Override
    public Template deserializeFromNetwork(FriendlyByteBuf friendlyByteBuf) {
        return this.template;
    }

    @Override
    @Override
    public Template unpack(A argumentType) {
        return this.template;
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template unpack(ArgumentType argumentType) {
        return this.unpack(argumentType);
    }

    @Override
    public /* synthetic */ ArgumentTypeInfo.Template deserializeFromNetwork(FriendlyByteBuf buf) {
        return this.deserializeFromNetwork(buf);
    }

    public final class Template
    implements ArgumentTypeInfo.Template<A> {
        private final Function<CommandBuildContext, A> constructor;

        public Template(Function<CommandBuildContext, A> typeSupplier) {
            this.constructor = typeSupplier;
        }

        @Override
        @Override
        public A instantiate(CommandBuildContext commandRegistryAccess) {
            return (ArgumentType)this.constructor.apply(commandRegistryAccess);
        }

        @Override
        @Override
        public ArgumentTypeInfo<A, ?> type() {
            return SingletonArgumentInfo.this;
        }
    }
}

