/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat DECIMAL_FORMAT = Util.make(new DecimalFormat("#"), format -> {
        format.setMaximumFractionDigits(15);
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    });
    private static final int MAX_CACHE_ENTRIES = 8;
    private final List<String> parameters;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> cache = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final ResourceLocation id;
    private final List<Entry<T>> entries;

    public MacroFunction(ResourceLocation id, List<Entry<T>> lines, List<String> varNames) {
        this.id = id;
        this.entries = lines;
        this.parameters = varNames;
    }

    @Override
    @Override
    public ResourceLocation id() {
        return this.id;
    }

    @Override
    @Override
    public InstantiatedFunction<T> instantiate(@Nullable CompoundTag arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        if (arguments == null) {
            throw new FunctionInstantiationException(Component.translatable("commands.function.error.missing_arguments", Component.translationArg(this.id())));
        }
        ArrayList<String> list = new ArrayList<String>(this.parameters.size());
        for (String string : this.parameters) {
            Tag tag = arguments.get(string);
            if (tag == null) {
                throw new FunctionInstantiationException(Component.translatable("commands.function.error.missing_argument", Component.translationArg(this.id()), string));
            }
            list.add(MacroFunction.stringify(tag));
        }
        InstantiatedFunction instantiatedFunction = (InstantiatedFunction)this.cache.getAndMoveToLast(list);
        if (instantiatedFunction != null) {
            return instantiatedFunction;
        }
        if (this.cache.size() >= 8) {
            this.cache.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction2 = this.substituteAndParse(this.parameters, list, dispatcher);
        this.cache.put(list, instantiatedFunction2);
        return instantiatedFunction2;
    }

    private static String stringify(Tag nbt) {
        if (nbt instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)nbt;
            return DECIMAL_FORMAT.format(floatTag.getAsFloat());
        }
        if (nbt instanceof DoubleTag) {
            DoubleTag doubleTag = (DoubleTag)nbt;
            return DECIMAL_FORMAT.format(doubleTag.getAsDouble());
        }
        if (nbt instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)nbt;
            return String.valueOf(byteTag.getAsByte());
        }
        if (nbt instanceof ShortTag) {
            ShortTag shortTag = (ShortTag)nbt;
            return String.valueOf(shortTag.getAsShort());
        }
        if (nbt instanceof LongTag) {
            LongTag longTag = (LongTag)nbt;
            return String.valueOf(longTag.getAsLong());
        }
        return nbt.getAsString();
    }

    private static void lookupValues(List<String> arguments, IntList indices, List<String> out) {
        out.clear();
        indices.forEach(index -> out.add((String)arguments.get(index)));
    }

    private InstantiatedFunction<T> substituteAndParse(List<String> varNames, List<String> arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        ArrayList list = new ArrayList(this.entries.size());
        ArrayList<String> list2 = new ArrayList<String>(arguments.size());
        for (Entry<T> entry : this.entries) {
            MacroFunction.lookupValues(arguments, entry.parameters(), list2);
            list.add(entry.instantiate(list2, dispatcher, this.id));
        }
        return new PlainTextFunction(this.id().withPath(path -> path + "/" + varNames.hashCode()), list);
    }

    static interface Entry<T> {
        public IntList parameters();

        public UnboundEntryAction<T> instantiate(List<String> var1, CommandDispatcher<T> var2, ResourceLocation var3) throws FunctionInstantiationException;
    }

    static class MacroEntry<T extends ExecutionCommandSource<T>>
    implements Entry<T> {
        private final StringTemplate template;
        private final IntList parameters;
        private final T compilationContext;

        public MacroEntry(StringTemplate invocation, IntList variableIndices, T source) {
            this.template = invocation;
            this.parameters = variableIndices;
            this.compilationContext = source;
        }

        @Override
        @Override
        public IntList parameters() {
            return this.parameters;
        }

        @Override
        @Override
        public UnboundEntryAction<T> instantiate(List<String> args, CommandDispatcher<T> dispatcher, ResourceLocation id) throws FunctionInstantiationException {
            String string = this.template.substitute(args);
            try {
                return CommandFunction.parseCommand(dispatcher, this.compilationContext, new StringReader(string));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new FunctionInstantiationException(Component.translatable("commands.function.error.parse", Component.translationArg(id), string, commandSyntaxException.getMessage()));
            }
        }
    }

    static class PlainTextEntry<T>
    implements Entry<T> {
        private final UnboundEntryAction<T> compiledAction;

        public PlainTextEntry(UnboundEntryAction<T> action) {
            this.compiledAction = action;
        }

        @Override
        @Override
        public IntList parameters() {
            return IntLists.emptyList();
        }

        @Override
        @Override
        public UnboundEntryAction<T> instantiate(List<String> args, CommandDispatcher<T> dispatcher, ResourceLocation id) {
            return this.compiledAction;
        }
    }
}

