/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution;

import javax.annotation.Nullable;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.EntryAction;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;

public interface ExecutionControl<T> {
    public void queueNext(EntryAction<T> var1);

    public void tracer(@Nullable TraceCallbacks var1);

    @Nullable
    public TraceCallbacks tracer();

    public Frame currentFrame();

    public static <T extends ExecutionCommandSource<T>> ExecutionControl<T> create(final ExecutionContext<T> context, final Frame frame) {
        return new ExecutionControl<T>(){

            @Override
            @Override
            public void queueNext(EntryAction<T> action) {
                context.queueNext(new CommandQueueEntry(frame, action));
            }

            @Override
            @Override
            public void tracer(@Nullable TraceCallbacks tracer) {
                context.tracer(tracer);
            }

            @Override
            @Nullable
            @Override
            public TraceCallbacks tracer() {
                return context.tracer();
            }

            @Override
            @Override
            public Frame currentFrame() {
                return frame;
            }
        };
    }
}

