/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.selector;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntitySelector {
    public static final int INFINITE = Integer.MAX_VALUE;
    public static final BiConsumer<Vec3, List<? extends Entity>> ORDER_ARBITRARY = (vec3d, list) -> {};
    private static final EntityTypeTest<Entity, ?> ANY_TYPE = new EntityTypeTest<Entity, Entity>(){

        @Override
        public Entity tryCast(Entity obj) {
            return obj;
        }

        @Override
        public Class<? extends Entity> getBaseClass() {
            return Entity.class;
        }
    };
    private final int maxResults;
    private final boolean includesEntities;
    private final boolean worldLimited;
    private final List<Predicate<Entity>> contextFreePredicates;
    private final MinMaxBounds.Doubles range;
    private final Function<Vec3, Vec3> position;
    @Nullable
    private final AABB aabb;
    private final BiConsumer<Vec3, List<? extends Entity>> order;
    private final boolean currentEntity;
    @Nullable
    private final String playerName;
    @Nullable
    private final UUID entityUUID;
    private final EntityTypeTest<Entity, ?> type;
    private final boolean usesSelector;

    public EntitySelector(int count, boolean includesNonPlayers, boolean localWorldOnly, List<Predicate<Entity>> predicates, MinMaxBounds.Doubles distance, Function<Vec3, Vec3> positionOffset, @Nullable AABB box, BiConsumer<Vec3, List<? extends Entity>> sorter, boolean senderOnly, @Nullable String playerName, @Nullable UUID uuid, @Nullable EntityType<?> type, boolean usesAt) {
        this.maxResults = count;
        this.includesEntities = includesNonPlayers;
        this.worldLimited = localWorldOnly;
        this.contextFreePredicates = predicates;
        this.range = distance;
        this.position = positionOffset;
        this.aabb = box;
        this.order = sorter;
        this.currentEntity = senderOnly;
        this.playerName = playerName;
        this.entityUUID = uuid;
        this.type = type == null ? ANY_TYPE : type;
        this.usesSelector = usesAt;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean includesEntities() {
        return this.includesEntities;
    }

    public boolean isSelfSelector() {
        return this.currentEntity;
    }

    public boolean isWorldLimited() {
        return this.worldLimited;
    }

    public boolean usesSelector() {
        return this.usesSelector;
    }

    private void checkPermissions(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.bypassSelectorPermissions && this.usesSelector && !source.hasPermission(2, "minecraft.command.selector")) {
            throw EntityArgument.ERROR_SELECTORS_NOT_ALLOWED.create();
        }
    }

    public Entity findSingleEntity(CommandSourceStack source) throws CommandSyntaxException {
        this.checkPermissions(source);
        List<? extends Entity> list = this.findEntities(source);
        if (list.isEmpty()) {
            throw EntityArgument.NO_ENTITIES_FOUND.create();
        }
        if (list.size() > 1) {
            throw EntityArgument.ERROR_NOT_SINGLE_ENTITY.create();
        }
        return list.get(0);
    }

    public List<? extends Entity> findEntities(CommandSourceStack source) throws CommandSyntaxException {
        this.checkPermissions(source);
        if (!this.includesEntities) {
            return this.findPlayers(source);
        }
        if (this.playerName != null) {
            ServerPlayer entityplayer = source.getServer().getPlayerList().getPlayerByName(this.playerName);
            return entityplayer == null ? List.of() : List.of(entityplayer);
        }
        if (this.entityUUID != null) {
            for (ServerLevel worldserver : source.getServer().getAllLevels()) {
                Entity entity = worldserver.getEntity(this.entityUUID);
                if (entity == null) continue;
                if (!entity.getType().isEnabled(source.enabledFeatures())) break;
                return List.of(entity);
            }
            return List.of();
        }
        Vec3 vec3d = this.position.apply(source.getPosition());
        AABB axisalignedbb = this.getAbsoluteAabb(vec3d);
        if (this.currentEntity) {
            Predicate<Entity> predicate = this.getPredicate(vec3d, axisalignedbb, null);
            return source.getEntity() != null && predicate.test(source.getEntity()) ? List.of(source.getEntity()) : List.of();
        }
        Predicate<Entity> predicate = this.getPredicate(vec3d, axisalignedbb, source.enabledFeatures());
        ObjectArrayList list = new ObjectArrayList();
        if (this.isWorldLimited()) {
            this.addEntities((List<Entity>)list, source.getLevel(), axisalignedbb, predicate);
        } else {
            for (ServerLevel worldserver1 : source.getServer().getAllLevels()) {
                this.addEntities((List<Entity>)list, worldserver1, axisalignedbb, predicate);
            }
        }
        return this.sortAndLimit(vec3d, (List)list);
    }

    private void addEntities(List<Entity> entities, ServerLevel world, @Nullable AABB box, Predicate<Entity> predicate) {
        int i = this.getResultLimit();
        if (entities.size() < i) {
            if (box != null) {
                world.getEntities(this.type, box, predicate, entities, i);
            } else {
                world.getEntities(this.type, predicate, entities, i);
            }
        }
    }

    private int getResultLimit() {
        return this.order == ORDER_ARBITRARY ? this.maxResults : Integer.MAX_VALUE;
    }

    public ServerPlayer findSinglePlayer(CommandSourceStack source) throws CommandSyntaxException {
        this.checkPermissions(source);
        List<ServerPlayer> list = this.findPlayers(source);
        if (list.size() != 1) {
            throw EntityArgument.NO_PLAYERS_FOUND.create();
        }
        return list.get(0);
    }

    public List<ServerPlayer> findPlayers(CommandSourceStack source) throws CommandSyntaxException {
        Object object;
        this.checkPermissions(source);
        if (this.playerName != null) {
            ServerPlayer entityplayer = source.getServer().getPlayerList().getPlayerByName(this.playerName);
            return entityplayer == null ? List.of() : List.of(entityplayer);
        }
        if (this.entityUUID != null) {
            ServerPlayer entityplayer = source.getServer().getPlayerList().getPlayer(this.entityUUID);
            return entityplayer == null ? List.of() : List.of(entityplayer);
        }
        Vec3 vec3d = this.position.apply(source.getPosition());
        AABB axisalignedbb = this.getAbsoluteAabb(vec3d);
        Predicate<Entity> predicate = this.getPredicate(vec3d, axisalignedbb, null);
        if (this.currentEntity) {
            ServerPlayer entityplayer1;
            Entity entity = source.getEntity();
            if (entity instanceof ServerPlayer && predicate.test(entityplayer1 = (ServerPlayer)entity)) {
                return List.of(entityplayer1);
            }
            return List.of();
        }
        int i = this.getResultLimit();
        if (this.isWorldLimited()) {
            object = source.getLevel().getPlayers(predicate, i);
        } else {
            object = new ObjectArrayList();
            for (ServerPlayer entityplayer2 : source.getServer().getPlayerList().getPlayers()) {
                if (!predicate.test(entityplayer2)) continue;
                ((List)object).add(entityplayer2);
                if (((List)object).size() < i) continue;
                return (List)object;
            }
        }
        return this.sortAndLimit(vec3d, (List)object);
    }

    @Nullable
    private AABB getAbsoluteAabb(Vec3 offset) {
        return this.aabb != null ? this.aabb.move(offset) : null;
    }

    private Predicate<Entity> getPredicate(Vec3 pos, @Nullable AABB box, @Nullable FeatureFlagSet enabledFeatures) {
        ObjectArrayList object;
        boolean flag2;
        boolean flag1;
        boolean flag = enabledFeatures != null;
        int i = (flag ? 1 : 0) + ((flag1 = box != null) ? 1 : 0) + ((flag2 = !this.range.isAny()) ? 1 : 0);
        if (i == 0) {
            object = this.contextFreePredicates;
        } else {
            ObjectArrayList list = new ObjectArrayList(this.contextFreePredicates.size() + i);
            list.addAll(this.contextFreePredicates);
            if (flag) {
                list.add(entity -> entity.getType().isEnabled(enabledFeatures));
            }
            if (flag1) {
                list.add(entity -> box.intersects(entity.getBoundingBox()));
            }
            if (flag2) {
                list.add(entity -> this.range.matchesSqr(entity.distanceToSqr(pos)));
            }
            object = list;
        }
        return Util.allOf(object);
    }

    private <T extends Entity> List<T> sortAndLimit(Vec3 pos, List<T> entities) {
        if (entities.size() > 1) {
            this.order.accept(pos, entities);
        }
        return entities.subList(0, Math.min(this.maxResults, entities.size()));
    }

    public static Component joinNames(List<? extends Entity> entities) {
        return ComponentUtils.formatList(entities, Entity::getDisplayName);
    }
}

