/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;

public class WorldCoordinate {
    private static final char PREFIX_RELATIVE = '~';
    public static final SimpleCommandExceptionType ERROR_EXPECTED_DOUBLE = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.double"));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_INT = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.missing.int"));
    private final boolean relative;
    private final double value;

    public WorldCoordinate(boolean relative, double value) {
        this.relative = relative;
        this.value = value;
    }

    public double get(double offset) {
        if (this.relative) {
            return this.value + offset;
        }
        return this.value;
    }

    public static WorldCoordinate parseDouble(StringReader reader, boolean centerIntegers) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)reader);
        }
        boolean bl = WorldCoordinate.isRelative(reader);
        int i = reader.getCursor();
        double d = reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
        String string = reader.getString().substring(i, reader.getCursor());
        if (bl && string.isEmpty()) {
            return new WorldCoordinate(true, 0.0);
        }
        if (!string.contains(".") && !bl && centerIntegers) {
            d += 0.5;
        }
        return new WorldCoordinate(bl, d);
    }

    public static WorldCoordinate parseInt(StringReader reader) throws CommandSyntaxException {
        double e;
        if (reader.canRead() && reader.peek() == '^') {
            throw Vec3Argument.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw ERROR_EXPECTED_INT.createWithContext((ImmutableStringReader)reader);
        }
        boolean bl = WorldCoordinate.isRelative(reader);
        if (reader.canRead() && reader.peek() != ' ') {
            double d = bl ? reader.readDouble() : (double)reader.readInt();
        } else {
            e = 0.0;
        }
        return new WorldCoordinate(bl, e);
    }

    public static boolean isRelative(StringReader reader) {
        boolean bl2;
        if (reader.peek() == '~') {
            boolean bl = true;
            reader.skip();
        } else {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof WorldCoordinate)) {
            return false;
        }
        WorldCoordinate worldCoordinate = (WorldCoordinate)object;
        if (this.relative != worldCoordinate.relative) {
            return false;
        }
        return Double.compare(worldCoordinate.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        int i = this.relative ? 1 : 0;
        long l = Double.doubleToLongBits(this.value);
        i = 31 * i + (int)(l ^ l >>> 32);
        return i;
    }

    public boolean isRelative() {
        return this.relative;
    }
}

